#pragma once

#include "../spmat.h"

/* geam_nnz_csr*/
alphasparse_status_t dcu_geam_nnz_csr(alphasparse_dcu_handle_t handle,
                                     ALPHA_INT m,
                                     ALPHA_INT n,
                                     ALPHA_INT nnz_A,
                                     const ALPHA_INT *csr_row_ptr_A,
                                     const ALPHA_INT *csr_col_ind_A,
                                     ALPHA_INT nnz_B,
                                     const ALPHA_INT *csr_row_ptr_B,
                                     const ALPHA_INT *csr_col_ind_B,
                                     ALPHA_INT *csr_row_ptr_C,
                                     ALPHA_INT *nnz_C);

/* spgemm_nnz_csr*/
alphasparse_status_t dcu_spgemm_nnz_csr(alphasparse_dcu_handle_t handle,
                                       ALPHA_INT m,
                                       ALPHA_INT n,
                                       ALPHA_INT k,
                                       ALPHA_INT nnz_A,
                                       const ALPHA_INT *csr_row_ptr_A,
                                       const ALPHA_INT *csr_col_ind_A,
                                       ALPHA_INT nnz_B,
                                       const ALPHA_INT *csr_row_ptr_B,
                                       const ALPHA_INT *csr_col_ind_B,
                                       ALPHA_INT nnz_D,
                                       const ALPHA_INT *csr_row_ptr_D,
                                       const ALPHA_INT *csr_col_ind_D,
                                       ALPHA_INT *csr_row_ptr_C,
                                       ALPHA_INT *nnz_C,
                                       const alphasparse_dcu_mat_info_t info_C,
                                       void *temp_buffer);

alphasparse_status_t dcu_spgemm_nnz_csr_transA(alphasparse_dcu_handle_t handle,
                                              ALPHA_INT m,
                                              ALPHA_INT n,
                                              ALPHA_INT k,
                                              ALPHA_INT nnz_A,
                                              const ALPHA_INT *csr_row_ptr_A,
                                              const ALPHA_INT *csr_col_ind_A,
                                              ALPHA_INT nnz_B,
                                              const ALPHA_INT *csr_row_ptr_B,
                                              const ALPHA_INT *csr_col_ind_B,
                                              ALPHA_INT nnz_D,
                                              const ALPHA_INT *csr_row_ptr_D,
                                              const ALPHA_INT *csr_col_ind_D,
                                              ALPHA_INT *csr_row_ptr_C,
                                              ALPHA_INT *nnz_C,
                                              const alphasparse_dcu_mat_info_t info_C,
                                              void *temp_buffer);

alphasparse_status_t dcu_spgemm_nnz_csr_conjA(alphasparse_dcu_handle_t handle,
                                             ALPHA_INT m,
                                             ALPHA_INT n,
                                             ALPHA_INT k,
                                             ALPHA_INT nnz_A,
                                             const ALPHA_INT *csr_row_ptr_A,
                                             const ALPHA_INT *csr_col_ind_A,
                                             ALPHA_INT nnz_B,
                                             const ALPHA_INT *csr_row_ptr_B,
                                             const ALPHA_INT *csr_col_ind_B,
                                             ALPHA_INT nnz_D,
                                             const ALPHA_INT *csr_row_ptr_D,
                                             const ALPHA_INT *csr_col_ind_D,
                                             ALPHA_INT *csr_row_ptr_C,
                                             ALPHA_INT *nnz_C,
                                             const alphasparse_dcu_mat_info_t info_C,
                                             void *temp_buffer);

alphasparse_status_t dcu_spgemm_nnz_csr_transB(alphasparse_dcu_handle_t handle,
                                              ALPHA_INT m,
                                              ALPHA_INT n,
                                              ALPHA_INT k,
                                              ALPHA_INT nnz_A,
                                              const ALPHA_INT *csr_row_ptr_A,
                                              const ALPHA_INT *csr_col_ind_A,
                                              ALPHA_INT nnz_B,
                                              const ALPHA_INT *csr_row_ptr_B,
                                              const ALPHA_INT *csr_col_ind_B,
                                              ALPHA_INT nnz_D,
                                              const ALPHA_INT *csr_row_ptr_D,
                                              const ALPHA_INT *csr_col_ind_D,
                                              ALPHA_INT *csr_row_ptr_C,
                                              ALPHA_INT *nnz_C,
                                              const alphasparse_dcu_mat_info_t info_C,
                                              void *temp_buffer);

alphasparse_status_t dcu_spgemm_nnz_csr_transAB(alphasparse_dcu_handle_t handle,
                                               ALPHA_INT m,
                                               ALPHA_INT n,
                                               ALPHA_INT k,
                                               ALPHA_INT nnz_A,
                                               const ALPHA_INT *csr_row_ptr_A,
                                               const ALPHA_INT *csr_col_ind_A,
                                               ALPHA_INT nnz_B,
                                               const ALPHA_INT *csr_row_ptr_B,
                                               const ALPHA_INT *csr_col_ind_B,
                                               ALPHA_INT nnz_D,
                                               const ALPHA_INT *csr_row_ptr_D,
                                               const ALPHA_INT *csr_col_ind_D,
                                               ALPHA_INT *csr_row_ptr_C,
                                               ALPHA_INT *nnz_C,
                                               const alphasparse_dcu_mat_info_t info_C,
                                               void *temp_buffer);

alphasparse_status_t dcu_spgemm_nnz_csr_conjAtransB(alphasparse_dcu_handle_t handle,
                                                   ALPHA_INT m,
                                                   ALPHA_INT n,
                                                   ALPHA_INT k,
                                                   ALPHA_INT nnz_A,
                                                   const ALPHA_INT *csr_row_ptr_A,
                                                   const ALPHA_INT *csr_col_ind_A,
                                                   ALPHA_INT nnz_B,
                                                   const ALPHA_INT *csr_row_ptr_B,
                                                   const ALPHA_INT *csr_col_ind_B,
                                                   ALPHA_INT nnz_D,
                                                   const ALPHA_INT *csr_row_ptr_D,
                                                   const ALPHA_INT *csr_col_ind_D,
                                                   ALPHA_INT *csr_row_ptr_C,
                                                   ALPHA_INT *nnz_C,
                                                   const alphasparse_dcu_mat_info_t info_C,
                                                   void *temp_buffer);

alphasparse_status_t dcu_spgemm_nnz_csr_conjB(alphasparse_dcu_handle_t handle,
                                             ALPHA_INT m,
                                             ALPHA_INT n,
                                             ALPHA_INT k,
                                             ALPHA_INT nnz_A,
                                             const ALPHA_INT *csr_row_ptr_A,
                                             const ALPHA_INT *csr_col_ind_A,
                                             ALPHA_INT nnz_B,
                                             const ALPHA_INT *csr_row_ptr_B,
                                             const ALPHA_INT *csr_col_ind_B,
                                             ALPHA_INT nnz_D,
                                             const ALPHA_INT *csr_row_ptr_D,
                                             const ALPHA_INT *csr_col_ind_D,
                                             ALPHA_INT *csr_row_ptr_C,
                                             ALPHA_INT *nnz_C,
                                             const alphasparse_dcu_mat_info_t info_C,
                                             void *temp_buffer);

alphasparse_status_t dcu_spgemm_nnz_csr_transAconjB(alphasparse_dcu_handle_t handle,
                                                   ALPHA_INT m,
                                                   ALPHA_INT n,
                                                   ALPHA_INT k,
                                                   ALPHA_INT nnz_A,
                                                   const ALPHA_INT *csr_row_ptr_A,
                                                   const ALPHA_INT *csr_col_ind_A,
                                                   ALPHA_INT nnz_B,
                                                   const ALPHA_INT *csr_row_ptr_B,
                                                   const ALPHA_INT *csr_col_ind_B,
                                                   ALPHA_INT nnz_D,
                                                   const ALPHA_INT *csr_row_ptr_D,
                                                   const ALPHA_INT *csr_col_ind_D,
                                                   ALPHA_INT *csr_row_ptr_C,
                                                   ALPHA_INT *nnz_C,
                                                   const alphasparse_dcu_mat_info_t info_C,
                                                   void *temp_buffer);

alphasparse_status_t dcu_spgemm_nnz_csr_conjAB(alphasparse_dcu_handle_t handle,
                                              ALPHA_INT m,
                                              ALPHA_INT n,
                                              ALPHA_INT k,
                                              ALPHA_INT nnz_A,
                                              const ALPHA_INT *csr_row_ptr_A,
                                              const ALPHA_INT *csr_col_ind_A,
                                              ALPHA_INT nnz_B,
                                              const ALPHA_INT *csr_row_ptr_B,
                                              const ALPHA_INT *csr_col_ind_B,
                                              ALPHA_INT nnz_D,
                                              const ALPHA_INT *csr_row_ptr_D,
                                              const ALPHA_INT *csr_col_ind_D,
                                              ALPHA_INT *csr_row_ptr_C,
                                              ALPHA_INT *nnz_C,
                                              const alphasparse_dcu_mat_info_t info_C,
                                              void *temp_buffer);