/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.swing.Icon;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.visitor.AllNodesVisitor;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public abstract class TransformNodesCommand
extends Command {
    protected final Collection<Node> nodes;
    protected final Map<Node, Command.OldNodeState> oldStates = new HashMap<Node, Command.OldNodeState>();

    protected final void storeOldState() {
        for (Node n : this.nodes) {
            this.oldStates.put(n, new Command.OldNodeState(n));
        }
    }

    protected TransformNodesCommand(Collection<? extends OsmPrimitive> objects) {
        super(objects.iterator().next().getDataSet());
        this.nodes = AllNodesVisitor.getAllNodes(objects);
        this.storeOldState();
    }

    public abstract void handleEvent(EastNorth var1);

    protected abstract void transformNodes();

    @Override
    public boolean executeCommand() {
        this.transformNodes();
        this.flagNodesAsModified();
        return true;
    }

    public void flagNodesAsModified() {
        for (Node n : this.nodes) {
            n.setModified(true);
        }
    }

    @Override
    public void undoCommand() {
        for (Node n : this.nodes) {
            Command.OldNodeState os = this.oldStates.get(n);
            n.setCoor(os.getLatLon());
            n.setModified(os.isModified());
        }
    }

    @Override
    public void fillModifiedData(Collection<OsmPrimitive> modified, Collection<OsmPrimitive> deleted, Collection<OsmPrimitive> added) {
    }

    @Override
    public Collection<? extends OsmPrimitive> getParticipatingPrimitives() {
        return this.nodes;
    }

    @Override
    public String getDescriptionText() {
        return I18n.trn("Transform {0} node", "Transform {0} nodes", this.nodes.size(), this.nodes.size());
    }

    @Override
    public Icon getDescriptionIcon() {
        return ImageProvider.get("data", "node");
    }

    public Collection<Node> getTransformedNodes() {
        return this.nodes;
    }

    public EastNorth getNodesCenter() {
        EastNorth sum = new EastNorth(0.0, 0.0);
        for (Node n : this.nodes) {
            EastNorth en = n.getEastNorth();
            sum = sum.add(en.east(), en.north());
        }
        return new EastNorth(sum.east() / (double)this.nodes.size(), sum.north() / (double)this.nodes.size());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.nodes, this.oldStates);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        TransformNodesCommand that = (TransformNodesCommand)obj;
        return Objects.equals(this.nodes, that.nodes) && Objects.equals(this.oldStates, that.oldStates);
    }
}

