/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command.conflict;

import java.util.Collection;
import java.util.Objects;
import javax.swing.Icon;
import org.openstreetmap.josm.command.conflict.ConflictResolveCommand;
import org.openstreetmap.josm.data.conflict.Conflict;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.conflict.pair.MergeDecisionType;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class CoordinateConflictResolveCommand
extends ConflictResolveCommand {
    private final Conflict<? extends OsmPrimitive> conflict;
    private final MergeDecisionType decision;

    public CoordinateConflictResolveCommand(Conflict<? extends OsmPrimitive> conflict, MergeDecisionType decision) {
        super(conflict.getMy().getDataSet());
        this.conflict = conflict;
        this.decision = decision;
    }

    @Override
    public String getDescriptionText() {
        return I18n.tr("Resolve conflicts in coordinates in {0}", this.conflict.getMy().getId());
    }

    @Override
    public Icon getDescriptionIcon() {
        return ImageProvider.get("data", "object");
    }

    @Override
    public boolean executeCommand() {
        super.executeCommand();
        if (this.decision != MergeDecisionType.KEEP_MINE) {
            if (this.decision == MergeDecisionType.KEEP_THEIR) {
                Node my = (Node)this.conflict.getMy();
                Node their = (Node)this.conflict.getTheir();
                my.setCoor(their.getCoor());
            } else {
                throw new IllegalStateException(I18n.tr("Cannot resolve undecided conflict.", new Object[0]));
            }
        }
        this.rememberConflict(this.conflict);
        return true;
    }

    @Override
    public void fillModifiedData(Collection<OsmPrimitive> modified, Collection<OsmPrimitive> deleted, Collection<OsmPrimitive> added) {
        modified.add(this.conflict.getMy());
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.conflict, this.decision});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        CoordinateConflictResolveCommand that = (CoordinateConflictResolveCommand)obj;
        return this.decision == that.decision && Objects.equals(this.conflict, that.conflict);
    }
}

