/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.dexlib2.immutable.instruction;

import com.android.tools.smali.dexlib2.Format;
import com.android.tools.smali.dexlib2.Opcode;
import com.android.tools.smali.dexlib2.iface.instruction.formats.Instruction21lh;
import com.android.tools.smali.dexlib2.immutable.instruction.ImmutableInstruction;
import com.android.tools.smali.dexlib2.util.Preconditions;
import javax.annotation.Nonnull;

public class ImmutableInstruction21lh
extends ImmutableInstruction
implements Instruction21lh {
    public static final Format FORMAT = Format.Format21lh;
    protected final int registerA;
    protected final long literal;

    public ImmutableInstruction21lh(@Nonnull Opcode opcode, int registerA, long literal) {
        super(opcode);
        this.registerA = Preconditions.checkByteRegister(registerA);
        this.literal = Preconditions.checkLongHatLiteral(literal);
    }

    public static ImmutableInstruction21lh of(Instruction21lh instruction) {
        if (instruction instanceof ImmutableInstruction21lh) {
            return (ImmutableInstruction21lh)instruction;
        }
        return new ImmutableInstruction21lh(instruction.getOpcode(), instruction.getRegisterA(), instruction.getWideLiteral());
    }

    @Override
    public int getRegisterA() {
        return this.registerA;
    }

    @Override
    public long getWideLiteral() {
        return this.literal;
    }

    @Override
    public short getHatLiteral() {
        return (short)(this.literal >>> 48);
    }

    @Override
    public Format getFormat() {
        return FORMAT;
    }
}

