/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.dexlib2.builder.instruction;

import com.android.tools.smali.dexlib2.Format;
import com.android.tools.smali.dexlib2.Opcode;
import com.android.tools.smali.dexlib2.builder.BuilderSwitchPayload;
import com.android.tools.smali.dexlib2.builder.SwitchLabelElement;
import com.android.tools.smali.dexlib2.builder.instruction.BuilderSwitchElement;
import com.android.tools.smali.dexlib2.iface.instruction.formats.SparseSwitchPayload;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class BuilderSparseSwitchPayload
extends BuilderSwitchPayload
implements SparseSwitchPayload {
    public static final Opcode OPCODE = Opcode.SPARSE_SWITCH_PAYLOAD;
    @Nonnull
    protected final List<BuilderSwitchElement> switchElements;

    public BuilderSparseSwitchPayload(@Nullable List<? extends SwitchLabelElement> switchElements) {
        super(OPCODE);
        this.switchElements = switchElements == null ? Collections.emptyList() : switchElements.stream().map(new Function<SwitchLabelElement, BuilderSwitchElement>(){

            @Override
            @Nullable
            public BuilderSwitchElement apply(@Nullable SwitchLabelElement element) {
                assert (element != null);
                return new BuilderSwitchElement(BuilderSparseSwitchPayload.this, element.key, element.target);
            }
        }).collect(Collectors.toList());
    }

    @Nonnull
    public List<BuilderSwitchElement> getSwitchElements() {
        return this.switchElements;
    }

    @Override
    public int getCodeUnits() {
        return 2 + this.switchElements.size() * 4;
    }

    @Override
    public Format getFormat() {
        return BuilderSparseSwitchPayload.OPCODE.format;
    }
}

