/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.appbundler;

import com.oracle.appbundler.Architecture;
import com.oracle.appbundler.Argument;
import com.oracle.appbundler.BundleDocument;
import com.oracle.appbundler.Environment;
import com.oracle.appbundler.IconContainer;
import com.oracle.appbundler.JLink;
import com.oracle.appbundler.Option;
import com.oracle.appbundler.PlistEntry;
import com.oracle.appbundler.Runtime;
import com.oracle.appbundler.TypeDeclaration;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.types.resources.FileResource;

public class AppBundlerTask
extends Task {
    private File outputDirectory = null;
    private String name = null;
    private String displayName = null;
    private String identifier = null;
    private File icon = null;
    private String executableName = "JavaAppLauncher";
    private String shortVersion = "1.0";
    private String version = "1.0";
    private String signature = "????";
    private String copyright = "";
    private String privileged = null;
    private String workingDirectory = null;
    private String minimumSystemVersion = "10.7";
    private boolean requiresAquaAppearance = false;
    private String jvmRequired = null;
    private boolean jrePreferred = false;
    private boolean jdkPreferred = false;
    private String applicationCategory = null;
    private boolean highResolutionCapable = true;
    private boolean supportsAutomaticGraphicsSwitching = true;
    private boolean hideDockIcon = false;
    private boolean isDebug = false;
    private boolean ignorePSN = false;
    private String mainClassName = null;
    private String jnlpLauncherName = null;
    private String jarLauncherName = null;
    private Runtime runtime = null;
    private JLink jlink = null;
    private ArrayList<FileSet> classPath = new ArrayList();
    private ArrayList<FileSet> modulePath = new ArrayList();
    private ArrayList<FileSet> libraryPath = new ArrayList();
    private ArrayList<Option> options = new ArrayList();
    private ArrayList<String> arguments = new ArrayList();
    private ArrayList<String> architectures = new ArrayList();
    private ArrayList<String> registeredProtocols = new ArrayList();
    private ArrayList<BundleDocument> bundleDocuments = new ArrayList();
    private ArrayList<TypeDeclaration> exportedTypeDeclarations = new ArrayList();
    private ArrayList<TypeDeclaration> importedTypeDeclarations = new ArrayList();
    private ArrayList<PlistEntry> plistEntries = new ArrayList();
    private ArrayList<Environment> environments = new ArrayList();
    private Reference classPathRef;
    private ArrayList<String> plistClassPaths = new ArrayList();
    private ArrayList<String> plistModulePaths = new ArrayList();
    private static final String EXECUTABLE_NAME = "JavaAppLauncher";
    private static final String DEFAULT_ICON_NAME = "GenericApp.icns";
    private static final String OS_TYPE_CODE = "APPL";
    private static final String PLIST_DTD = "<!DOCTYPE plist PUBLIC \"-//Apple//DTD PLIST 1.0//EN\" \"http://www.apple.com/DTDs/PropertyList-1.0.dtd\">";
    private static final String PLIST_TAG = "plist";
    private static final String PLIST_VERSION_ATTRIBUTE = "version";
    private static final String DICT_TAG = "dict";
    private static final String KEY_TAG = "key";
    private static final String ARRAY_TAG = "array";
    private static final String STRING_TAG = "string";
    private static final int BUFFER_SIZE = 2048;

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public void setIcon(File icon) {
        this.icon = icon;
    }

    public void setExecutableName(String executable) {
        this.executableName = executable;
    }

    public void setShortVersion(String shortVersion) {
        this.shortVersion = shortVersion;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public void setCopyright(String copyright) {
        this.copyright = copyright;
    }

    public void setPrivileged(String privileged) {
        this.privileged = privileged;
    }

    public void setWorkingDirectory(String workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public void setJVMRequired(String v) {
        this.jvmRequired = v;
    }

    public void setJREPreferred(boolean preferred) {
        this.jrePreferred = preferred;
    }

    public void setJDKPreferred(boolean preferred) {
        this.jdkPreferred = preferred;
    }

    public void setMinimumSystemVersion(String v) {
        this.minimumSystemVersion = v;
    }

    public void setApplicationCategory(String applicationCategory) {
        this.applicationCategory = applicationCategory;
    }

    public void setHighResolutionCapable(boolean highResolutionCapable) {
        this.highResolutionCapable = highResolutionCapable;
    }

    public void setHideDockIcon(boolean hideDock) {
        this.hideDockIcon = hideDock;
    }

    public void setDebug(boolean enabled) {
        this.isDebug = enabled;
    }

    public void setSupportsAutomaticGraphicsSwitching(boolean supportsAutomaticGraphicsSwitching) {
        this.supportsAutomaticGraphicsSwitching = supportsAutomaticGraphicsSwitching;
    }

    public void setIgnorePSN(boolean ignorePSN) {
        this.ignorePSN = ignorePSN;
    }

    public void setMainClassName(String mainClassName) {
        this.mainClassName = mainClassName;
    }

    public void setJnlpLauncherName(String jnlpLauncherName) {
        this.jnlpLauncherName = jnlpLauncherName;
    }

    public void setJarLauncherName(String jarLauncherName) {
        this.jarLauncherName = jarLauncherName;
    }

    public void addConfiguredRuntime(Runtime runtime) throws BuildException {
        if (this.runtime != null) {
            throw new BuildException("Runtime already specified.");
        }
        if (this.jlink != null) {
            throw new BuildException("Cannot specify runtime and jlink together.");
        }
        this.runtime = runtime;
    }

    public void addConfiguredJLink(JLink jlink) throws BuildException {
        if (this.jlink != null) {
            throw new BuildException("JLink already specified.");
        }
        if (this.runtime != null) {
            throw new BuildException("Cannot specify runtime and jlink together.");
        }
        jlink.setTask(this);
        this.jlink = jlink;
    }

    public void setClasspathRef(Reference ref) {
        this.classPathRef = ref;
    }

    public void setPlistClassPaths(String plistClassPaths) {
        for (String tok : plistClassPaths.split("\\s*,\\s*")) {
            this.plistClassPaths.add(tok);
        }
    }

    public void setPlistModulePaths(String plistModulePaths) {
        for (String tok : plistModulePaths.split("\\s*,\\s*")) {
            this.plistModulePaths.add(tok);
        }
    }

    public void addConfiguredClassPath(FileSet classPath) {
        this.classPath.add(classPath);
    }

    public void addConfiguredModulePath(FileSet modulePath) {
        this.modulePath.add(modulePath);
    }

    public void addConfiguredLibraryPath(FileSet libraryPath) {
        this.libraryPath.add(libraryPath);
    }

    public void addConfiguredBundleDocument(BundleDocument document) {
        if (document.getContentTypes() == null && document.getExtensions() == null) {
            throw new BuildException("Document content type or extension is required.");
        }
        this.bundleDocuments.add(document);
    }

    public void addConfiguredTypeDeclaration(TypeDeclaration typeDeclaration) {
        if (typeDeclaration.getIdentifier() == null) {
            throw new BuildException("Type declarations must have an identifier.");
        }
        if (typeDeclaration.isImported()) {
            this.importedTypeDeclarations.add(typeDeclaration);
        } else {
            this.exportedTypeDeclarations.add(typeDeclaration);
        }
    }

    public void addConfiguredPlistEntry(PlistEntry plistEntry) {
        if (plistEntry.getKey() == null) {
            throw new BuildException("Name is required.");
        }
        if (plistEntry.getValue() == null) {
            throw new BuildException("Value is required.");
        }
        if (plistEntry.getType() == null) {
            plistEntry.setType(STRING_TAG);
        }
        this.plistEntries.add(plistEntry);
    }

    public void addConfiguredEnvironment(Environment environment) {
        if (environment.getName() == null) {
            throw new BuildException("Name is required.");
        }
        if (environment.getValue() == null) {
            throw new BuildException("Value is required.");
        }
        this.environments.add(environment);
    }

    public void addConfiguredOption(Option option) throws BuildException {
        String value = option.getValue();
        if (value == null) {
            throw new BuildException("Value is required.");
        }
        this.options.add(option);
    }

    public void addConfiguredArgument(Argument argument) throws BuildException {
        String value = argument.getValue();
        if (value == null) {
            throw new BuildException("Value is required.");
        }
        this.arguments.add(value);
    }

    public void addConfiguredScheme(Argument argument) throws BuildException {
        String value = argument.getValue();
        if (value == null) {
            throw new BuildException("Value is required.");
        }
        this.registeredProtocols.add(value);
    }

    public void addConfiguredArch(Architecture architecture) throws BuildException {
        String name = architecture.getName();
        if (name == null) {
            throw new BuildException("Name is required.");
        }
        this.architectures.add(name);
    }

    public void execute() throws BuildException {
        if (this.outputDirectory == null) {
            throw new IllegalStateException("Output directory is required.");
        }
        if (!this.outputDirectory.exists()) {
            throw new IllegalStateException("Output directory does not exist.");
        }
        if (!this.outputDirectory.isDirectory()) {
            throw new IllegalStateException("Invalid output directory.");
        }
        if (this.name == null) {
            throw new IllegalStateException("Name is required.");
        }
        if (this.displayName == null) {
            throw new IllegalStateException("Display name is required.");
        }
        if (this.identifier == null) {
            throw new IllegalStateException("Identifier is required.");
        }
        if (this.icon != null) {
            if (!this.icon.exists()) {
                throw new IllegalStateException("Icon does not exist.");
            }
            if (this.icon.isDirectory()) {
                throw new IllegalStateException("Invalid icon.");
            }
        }
        if (this.shortVersion == null) {
            throw new IllegalStateException("Short version is required.");
        }
        if (this.signature == null || this.signature.trim().length() != 4) {
            throw new IllegalStateException("Invalid or missing signature.");
        }
        if (this.copyright == null) {
            throw new IllegalStateException("Copyright is required.");
        }
        if (this.jnlpLauncherName == null && this.mainClassName == null) {
            throw new IllegalStateException("Main class name or JNLP launcher name is required.");
        }
        try {
            System.out.println("Creating app bundle: " + this.name);
            File rootDirectory = new File(this.outputDirectory, this.name + ".app");
            AppBundlerTask.delete(rootDirectory);
            rootDirectory.mkdir();
            File contentsDirectory = new File(rootDirectory, "Contents");
            contentsDirectory.mkdir();
            File macOSDirectory = new File(contentsDirectory, "MacOS");
            macOSDirectory.mkdir();
            File javaDirectory = new File(contentsDirectory, "Java");
            javaDirectory.mkdir();
            File plugInsDirectory = new File(contentsDirectory, "PlugIns");
            plugInsDirectory.mkdir();
            File resourcesDirectory = new File(contentsDirectory, "Resources");
            resourcesDirectory.mkdir();
            File infoPlistFile = new File(contentsDirectory, "Info.plist");
            infoPlistFile.createNewFile();
            this.writeInfoPlist(infoPlistFile);
            File pkgInfoFile = new File(contentsDirectory, "PkgInfo");
            pkgInfoFile.createNewFile();
            this.writePkgInfo(pkgInfoFile);
            File executableFile = new File(macOSDirectory, this.executableName);
            AppBundlerTask.copy(((Object)((Object)this)).getClass().getResource(EXECUTABLE_NAME), executableFile);
            executableFile.setExecutable(true, false);
            this.copyResources(resourcesDirectory);
            this.copyRuntime(plugInsDirectory);
            this.copyClassPathEntries(javaDirectory);
            this.copyModulePathEntries(javaDirectory);
            this.copyClassPathRefEntries(javaDirectory);
            this.copyLibraryPathEntries(macOSDirectory);
            this.copyIcon(resourcesDirectory);
            this.copyDocumentIcons(this.bundleDocuments, resourcesDirectory);
            this.copyDocumentIcons(this.exportedTypeDeclarations, resourcesDirectory);
            this.copyDocumentIcons(this.importedTypeDeclarations, resourcesDirectory);
        }
        catch (IOException exception) {
            throw new BuildException((Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyResources(File resourcesDirectory) throws IOException {
        InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream("res.zip");
        try (ZipInputStream zipInputStream = new ZipInputStream(inputStream);){
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            while (zipEntry != null) {
                File file = new File(resourcesDirectory, zipEntry.getName());
                if (zipEntry.isDirectory()) {
                    file.mkdirs();
                } else {
                    file.getParentFile().mkdirs();
                    try (BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(file), 2048);){
                        int b = zipInputStream.read();
                        while (b != -1) {
                            ((OutputStream)outputStream).write(b);
                            b = zipInputStream.read();
                        }
                        ((OutputStream)outputStream).flush();
                    }
                }
                zipEntry = zipInputStream.getNextEntry();
            }
        }
    }

    private void copyRuntime(File plugInsDirectory) throws IOException {
        if (this.runtime != null) {
            this.runtime.copyTo(plugInsDirectory);
        } else if (this.jlink != null) {
            this.jlink.copyTo(plugInsDirectory);
        }
    }

    private void copyClassPathRefEntries(File javaDirectory) throws IOException {
        if (this.classPathRef != null) {
            Path classpath = (Path)this.classPathRef.getReferencedObject(this.getProject());
            for (Object resource : classpath) {
                if (!(resource instanceof FileResource)) continue;
                FileResource fileResource = (FileResource)resource;
                File source = fileResource.getFile();
                File destination = new File(javaDirectory, source.getName());
                AppBundlerTask.copy(source, destination);
            }
        }
    }

    private void copyClassPathEntries(File javaDirectory) throws IOException {
        this.copyJavaDirectoryEntries(this.classPath, javaDirectory);
    }

    private void copyModulePathEntries(File javaDirectory) throws IOException {
        this.copyJavaDirectoryEntries(this.modulePath, javaDirectory);
    }

    private void copyJavaDirectoryEntries(Collection<FileSet> fileSets, File javaDirectory) throws IOException {
        for (FileSet fileSet : fileSets) {
            File classPathDirectory = fileSet.getDir();
            DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(this.getProject());
            String[] includedFiles = directoryScanner.getIncludedFiles();
            for (int i = 0; i < includedFiles.length; ++i) {
                String includedFile = includedFiles[i];
                File source = new File(classPathDirectory, includedFile);
                File destination = new File(javaDirectory, new File(includedFile).getName());
                AppBundlerTask.copy(source, destination);
            }
        }
    }

    private void copyLibraryPathEntries(File macOSDirectory) throws IOException {
        for (FileSet fileSet : this.libraryPath) {
            File libraryPathDirectory = fileSet.getDir();
            DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(this.getProject());
            String[] includedFiles = directoryScanner.getIncludedFiles();
            for (int i = 0; i < includedFiles.length; ++i) {
                String includedFile = includedFiles[i];
                File source = new File(libraryPathDirectory, includedFile);
                File destination = new File(macOSDirectory, new File(includedFile).getName());
                AppBundlerTask.copy(source, destination);
            }
        }
    }

    private void copyIcon(File resourcesDirectory) throws IOException {
        if (this.icon == null) {
            AppBundlerTask.copy(((Object)((Object)this)).getClass().getResource(DEFAULT_ICON_NAME), new File(resourcesDirectory, DEFAULT_ICON_NAME));
        } else {
            AppBundlerTask.copy(this.icon, new File(resourcesDirectory, this.icon.getName()));
        }
    }

    public void copyDocumentIcons(ArrayList<? extends IconContainer> iconContainers, File resourcesDirectory) throws IOException {
        for (IconContainer iconContainer : iconContainers) {
            File ifile;
            if (!iconContainer.hasIcon() || (ifile = iconContainer.getIconFile()) == null) continue;
            this.copyDocumentIcon(ifile, resourcesDirectory);
        }
    }

    private void copyDocumentIcon(File ifile, File resourcesDirectory) throws IOException {
        if (ifile == null) {
            return;
        }
        AppBundlerTask.copy(ifile, new File(resourcesDirectory, ifile.getName()));
    }

    private void writeInfoPlist(File file) throws IOException {
        XMLOutputFactory output = XMLOutputFactory.newInstance();
        try (BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8));){
            XMLStreamWriter xout = output.createXMLStreamWriter(out);
            xout.writeStartDocument();
            xout.writeCharacters("\n");
            xout.writeDTD(PLIST_DTD);
            xout.writeCharacters("\n");
            xout.writeStartElement(PLIST_TAG);
            xout.writeAttribute(PLIST_VERSION_ATTRIBUTE, "1.0");
            xout.writeCharacters("\n");
            this.writeIndentation(xout, 1);
            xout.writeStartElement(DICT_TAG);
            xout.writeCharacters("\n");
            this.writeProperty(xout, "CFBundleDevelopmentRegion", "English", 2);
            this.writeProperty(xout, "CFBundleExecutable", this.executableName, 2);
            this.writeProperty(xout, "CFBundleIconFile", this.icon == null ? DEFAULT_ICON_NAME : this.icon.getName(), 2);
            this.writeProperty(xout, "CFBundleIdentifier", this.identifier, 2);
            this.writeProperty(xout, "CFBundleDisplayName", this.displayName, 2);
            this.writeProperty(xout, "CFBundleInfoDictionaryVersion", "6.0", 2);
            this.writeProperty(xout, "CFBundleName", this.name, 2);
            this.writeProperty(xout, "CFBundlePackageType", OS_TYPE_CODE, 2);
            this.writeProperty(xout, "CFBundleShortVersionString", this.shortVersion, 2);
            this.writeProperty(xout, "CFBundleVersion", this.version, 2);
            this.writeProperty(xout, "CFBundleSignature", this.signature, 2);
            this.writeProperty(xout, "NSHumanReadableCopyright", this.copyright, 2);
            this.writeProperty(xout, "LSMinimumSystemVersion", this.minimumSystemVersion, 2);
            this.writeProperty(xout, "LSApplicationCategoryType", this.applicationCategory, 2);
            this.writeProperty(xout, "LSUIElement", this.hideDockIcon, 2);
            this.writeProperty(xout, "NSHighResolutionCapable", this.highResolutionCapable, 2);
            this.writeProperty(xout, "NSSupportsAutomaticGraphicsSwitching", this.supportsAutomaticGraphicsSwitching, 2);
            this.writeProperty(xout, "IgnorePSN", this.ignorePSN, 2);
            this.writeProperty(xout, "NSRequiresAquaSystemAppearance", this.requiresAquaAppearance, 2);
            if (this.registeredProtocols.size() > 0) {
                this.writeKey(xout, "CFBundleURLTypes", 2);
                this.writeIndentation(xout, 2);
                xout.writeStartElement(ARRAY_TAG);
                xout.writeCharacters("\n");
                this.writeIndentation(xout, 3);
                xout.writeStartElement(DICT_TAG);
                xout.writeCharacters("\n");
                this.writeProperty(xout, "CFBundleURLName", this.identifier, 4);
                this.writeStringArray(xout, "CFBundleURLSchemes", this.registeredProtocols, 4);
                this.writeIndentation(xout, 3);
                xout.writeEndElement();
                xout.writeCharacters("\n");
                this.writeIndentation(xout, 2);
                xout.writeEndElement();
                xout.writeCharacters("\n");
            }
            if (this.runtime != null) {
                this.writeProperty(xout, "JVMRuntime", this.runtime.getDir().getParentFile().getParentFile().getName(), 2);
            } else if (this.jlink != null) {
                this.writeProperty(xout, "JVMRuntime", this.jlink.getDir().getParentFile().getParentFile().getName(), 2);
            }
            if (this.jvmRequired != null) {
                this.writeProperty(xout, "JVMVersion", this.jvmRequired, 2);
            }
            this.writeProperty(xout, "JVMRunPrivileged", this.privileged, 2);
            this.writeProperty(xout, "JREPreferred", this.jrePreferred, 2);
            this.writeProperty(xout, "JDKPreferred", this.jdkPreferred, 2);
            this.writeProperty(xout, "WorkingDirectory", this.workingDirectory, 2);
            this.writeProperty(xout, "JVMJNLPLauncher", this.jnlpLauncherName, 2);
            this.writeProperty(xout, "JVMMainClassName", this.mainClassName, 2);
            if (!this.plistClassPaths.isEmpty()) {
                this.writeStringArray(xout, "JVMClassPath", this.plistClassPaths, 2);
            }
            if (!this.plistModulePaths.isEmpty()) {
                this.writeStringArray(xout, "JVMModulePath", this.plistModulePaths, 2);
            }
            this.writeProperty(xout, "JVMDebug", this.isDebug, 2);
            this.writeProperty(xout, "JVMJARLauncher", this.jarLauncherName, 2);
            this.writeKey(xout, "CFBundleDocumentTypes", 2);
            this.writeBundleDocuments(xout, this.bundleDocuments, 2);
            if (!this.exportedTypeDeclarations.isEmpty()) {
                this.writeKey(xout, "UTExportedTypeDeclarations", 2);
                this.writeTypeDeclarations(xout, this.exportedTypeDeclarations, 2);
            }
            if (!this.importedTypeDeclarations.isEmpty()) {
                this.writeKey(xout, "UTImportedTypeDeclarations", 2);
                this.writeTypeDeclarations(xout, this.importedTypeDeclarations, 2);
            }
            if (!this.architectures.isEmpty()) {
                this.writeStringArray(xout, "LSArchitecturePriority", this.architectures, 2);
            }
            this.writeKey(xout, "LSEnvironment", 2);
            this.writeIndentation(xout, 2);
            xout.writeStartElement(DICT_TAG);
            xout.writeCharacters("\n");
            this.writeKey(xout, "LC_CTYPE", 3);
            this.writeString(xout, "UTF-8", 3);
            for (Environment environment : this.environments) {
                this.writeProperty(xout, environment.getName(), environment.getValue(), 3);
            }
            this.writeIndentation(xout, 2);
            xout.writeEndElement();
            xout.writeCharacters("\n");
            this.writeKey(xout, "JVMOptions", 2);
            this.writeIndentation(xout, 2);
            xout.writeStartElement(ARRAY_TAG);
            xout.writeCharacters("\n");
            for (Option option : this.options) {
                if (option.getName() != null) continue;
                this.writeString(xout, option.getValue(), 3);
            }
            this.writeIndentation(xout, 2);
            xout.writeEndElement();
            xout.writeCharacters("\n");
            this.writeKey(xout, "JVMDefaultOptions", 2);
            this.writeIndentation(xout, 2);
            xout.writeStartElement(DICT_TAG);
            xout.writeCharacters("\n");
            for (Option option : this.options) {
                if (option.getName() == null) continue;
                this.writeProperty(xout, option.getName(), option.getValue(), 3);
            }
            this.writeIndentation(xout, 2);
            xout.writeEndElement();
            xout.writeCharacters("\n");
            this.writeStringArray(xout, "JVMArguments", this.arguments, 2);
            for (PlistEntry item : this.plistEntries) {
                this.writeKey(xout, item.getKey(), 2);
                this.writeValue(xout, item.getType(), item.getValue(), 2);
            }
            this.writeIndentation(xout, 1);
            xout.writeEndElement();
            xout.writeCharacters("\n");
            xout.writeEndElement();
            xout.writeCharacters("\n");
            xout.writeEndDocument();
            xout.writeCharacters("\n");
            ((Writer)out).flush();
        }
    }

    private void writeKey(XMLStreamWriter xout, String key, int indentationDepth) throws XMLStreamException {
        this.writeIndentation(xout, indentationDepth);
        xout.writeStartElement(KEY_TAG);
        xout.writeCharacters(key);
        xout.writeEndElement();
        xout.writeCharacters("\n");
    }

    private void writeValue(XMLStreamWriter xout, String type, String value, int indentationDepth) throws XMLStreamException {
        if (type == null) {
            type = STRING_TAG;
        }
        if ("boolean".equals(type)) {
            this.writeBoolean(xout, "true".equals(value), indentationDepth);
        } else {
            this.writeIndentation(xout, indentationDepth);
            xout.writeStartElement(type);
            xout.writeCharacters(value);
            xout.writeEndElement();
            xout.writeCharacters("\n");
        }
    }

    private void writeString(XMLStreamWriter xout, String value, int indentationDepth) throws XMLStreamException {
        this.writeIndentation(xout, indentationDepth);
        xout.writeStartElement(STRING_TAG);
        xout.writeCharacters(value);
        xout.writeEndElement();
        xout.writeCharacters("\n");
    }

    private void writeBoolean(XMLStreamWriter xout, boolean value, int indentationDepth) throws XMLStreamException {
        this.writeIndentation(xout, indentationDepth);
        xout.writeEmptyElement(value ? "true" : "false");
        xout.writeCharacters("\n");
    }

    private void writeProperty(XMLStreamWriter xout, String key, Boolean value, int indentationDepth) throws XMLStreamException {
        if (value != null) {
            this.writeKey(xout, key, indentationDepth);
            this.writeBoolean(xout, value, indentationDepth);
        }
    }

    private void writeProperty(XMLStreamWriter xout, String key, Object value, int indentationDepth) throws XMLStreamException {
        if (value != null) {
            this.writeKey(xout, key, indentationDepth);
            this.writeString(xout, value.toString(), indentationDepth);
        }
    }

    public void writeStringArray(XMLStreamWriter xout, String key, Iterable<String> values, int indentationDepth) throws XMLStreamException {
        if (values != null) {
            this.writeKey(xout, key, indentationDepth);
            this.writeIndentation(xout, indentationDepth);
            xout.writeStartElement(ARRAY_TAG);
            xout.writeCharacters("\n");
            for (String singleValue : values) {
                this.writeString(xout, singleValue, indentationDepth + 1);
            }
            this.writeIndentation(xout, indentationDepth);
            xout.writeEndElement();
            xout.writeCharacters("\n");
        }
    }

    public void writeBundleDocuments(XMLStreamWriter xout, ArrayList<BundleDocument> bundleDocuments, int indentationDepth) throws XMLStreamException {
        this.writeIndentation(xout, indentationDepth);
        xout.writeStartElement(ARRAY_TAG);
        xout.writeCharacters("\n");
        for (BundleDocument bundleDocument : bundleDocuments) {
            this.writeIndentation(xout, indentationDepth + 1);
            xout.writeStartElement(DICT_TAG);
            xout.writeCharacters("\n");
            List<String> contentTypes = bundleDocument.getContentTypes();
            if (contentTypes != null) {
                this.writeStringArray(xout, "LSItemContentTypes", contentTypes, indentationDepth + 2);
            } else {
                this.writeStringArray(xout, "CFBundleTypeExtensions", bundleDocument.getExtensions(), indentationDepth + 2);
                this.writeProperty(xout, "LSTypeIsPackage", bundleDocument.isPackage(), indentationDepth + 2);
            }
            this.writeStringArray(xout, "NSExportableTypes", bundleDocument.getExportableTypes(), indentationDepth + 2);
            File ifile = bundleDocument.getIconFile();
            this.writeProperty(xout, "CFBundleTypeIconFile", ifile != null ? ifile.getName() : bundleDocument.getIcon(), indentationDepth + 2);
            this.writeProperty(xout, "CFBundleTypeName", bundleDocument.getName(), indentationDepth + 2);
            this.writeProperty(xout, "CFBundleTypeRole", bundleDocument.getRole(), indentationDepth + 2);
            this.writeProperty(xout, "LSHandlerRank", bundleDocument.getHandlerRank(), indentationDepth + 2);
            this.writeIndentation(xout, indentationDepth + 1);
            xout.writeEndElement();
            xout.writeCharacters("\n");
        }
        this.writeIndentation(xout, indentationDepth);
        xout.writeEndElement();
        xout.writeCharacters("\n");
    }

    public void writeTypeDeclarations(XMLStreamWriter xout, ArrayList<TypeDeclaration> typeDeclarations, int indentationDepth) throws XMLStreamException {
        this.writeIndentation(xout, indentationDepth);
        xout.writeStartElement(ARRAY_TAG);
        xout.writeCharacters("\n");
        for (TypeDeclaration typeDeclaration : typeDeclarations) {
            this.writeIndentation(xout, indentationDepth + 1);
            xout.writeStartElement(DICT_TAG);
            xout.writeCharacters("\n");
            this.writeProperty(xout, "UTTypeIdentifier", typeDeclaration.getIdentifier(), indentationDepth + 2);
            this.writeProperty(xout, "UTTypeReferenceURL", typeDeclaration.getReferenceUrl(), indentationDepth + 2);
            this.writeProperty(xout, "UTTypeDescription", typeDeclaration.getDescription(), indentationDepth + 2);
            File ifile = typeDeclaration.getIconFile();
            this.writeProperty(xout, "UTTypeIconFile", ifile != null ? ifile.getName() : typeDeclaration.getIcon(), indentationDepth + 2);
            this.writeStringArray(xout, "UTTypeConformsTo", typeDeclaration.getConformsTo(), indentationDepth + 2);
            this.writeKey(xout, "UTTypeTagSpecification", indentationDepth + 2);
            this.writeIndentation(xout, indentationDepth + 2);
            xout.writeStartElement(DICT_TAG);
            xout.writeCharacters("\n");
            this.writeStringArray(xout, "com.apple.ostype", typeDeclaration.getOsTypes(), indentationDepth + 3);
            this.writeStringArray(xout, "public.filename-extension", typeDeclaration.getExtensions(), indentationDepth + 3);
            this.writeStringArray(xout, "public.mime-type", typeDeclaration.getMimeTypes(), indentationDepth + 3);
            this.writeIndentation(xout, indentationDepth + 2);
            xout.writeEndElement();
            xout.writeCharacters("\n");
            this.writeIndentation(xout, indentationDepth + 1);
            xout.writeEndElement();
            xout.writeCharacters("\n");
        }
        this.writeIndentation(xout, indentationDepth);
        xout.writeEndElement();
        xout.writeCharacters("\n");
    }

    public void writeIndentation(XMLStreamWriter xout, int depth) throws XMLStreamException {
        for (int i = 0; i < depth; ++i) {
            xout.writeCharacters("    ");
        }
    }

    private void writePkgInfo(File file) throws IOException {
        try (BufferedWriter out = new BufferedWriter(new FileWriter(file));){
            out.write(OS_TYPE_CODE + this.signature);
            ((Writer)out).flush();
        }
    }

    private static void delete(File file) throws IOException {
        java.nio.file.Path filePath = file.toPath();
        if (Files.exists(filePath, LinkOption.NOFOLLOW_LINKS)) {
            if (Files.isDirectory(filePath, LinkOption.NOFOLLOW_LINKS)) {
                File[] files = file.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    AppBundlerTask.delete(files[i]);
                }
            }
            Files.delete(filePath);
        }
    }

    private static void copy(URL location, File file) throws IOException {
        try (InputStream in = location.openStream();){
            Files.copy(in, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Exception exc) {
            System.err.println("Trying to copy " + location + " to " + file);
            throw exc;
        }
    }

    static void copy(File source, File destination) throws IOException {
        java.nio.file.Path sourcePath = source.toPath();
        java.nio.file.Path destinationPath = destination.toPath();
        destination.getParentFile().mkdirs();
        Files.copy(sourcePath, destinationPath, StandardCopyOption.REPLACE_EXISTING);
        if (Files.isDirectory(sourcePath, new LinkOption[0])) {
            String[] files = source.list();
            for (int i = 0; i < files.length; ++i) {
                String file = files[i];
                AppBundlerTask.copy(new File(source, file), new File(destination, file));
            }
        }
    }
}

