/*
 * Decompiled with CFR 0.152.
 */
package org.basex.http.restxq;

import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.basex.http.BaseXServlet;
import org.basex.http.HTTPConnection;
import org.basex.http.HTTPStatus;
import org.basex.http.restxq.RestXqFunction;
import org.basex.http.restxq.RestXqResponse;
import org.basex.http.web.WebModules;
import org.basex.http.web.WebResponse;
import org.basex.query.QueryException;
import org.basex.util.http.Method;

public final class RestXqServlet
extends BaseXServlet {
    @Override
    protected void run(HTTPConnection conn) throws Exception {
        if (conn.request.getPathInfo() == null) {
            conn.redirect("/");
            return;
        }
        WebModules modules = WebModules.get(conn.context);
        if (conn.path().equals("/.init")) {
            modules.init(false);
            return;
        }
        RestXqFunction func = modules.restxq(conn, null);
        boolean body = true;
        if (func == null) {
            if (conn.method.equals(Method.OPTIONS.name())) {
                conn.response.setHeader("Allow", Stream.of(Method.values()).map(Enum::name).collect(Collectors.joining(",")));
                return;
            }
            if (conn.method.equals(Method.HEAD.name())) {
                conn.method = Method.GET.name();
                func = modules.restxq(conn, null);
                body = false;
            }
            if (func == null) {
                throw HTTPStatus.SERVICE_NOT_FOUND.get(new Object[0]);
            }
        }
        try {
            for (RestXqFunction check : modules.checks(conn)) {
                if (new RestXqResponse(conn).create(check, func, body) == WebResponse.Response.NONE) continue;
                return;
            }
            if (new RestXqResponse(conn).create(func, null, body) != WebResponse.Response.CUSTOM) {
                conn.log(200, "");
            }
        }
        catch (QueryException ex) {
            func = modules.restxq(conn, ex.qname());
            if (func == null) {
                throw ex;
            }
            new RestXqResponse(conn).create(func, (Object)ex, body);
        }
    }
}

