/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import java.util.function.IntConsumer;
import org.basex.build.Builder;
import org.basex.core.Text;
import org.basex.core.cmd.ACreate;
import org.basex.core.cmd.Add;
import org.basex.core.cmd.BinaryPut;
import org.basex.core.parse.CmdBuilder;
import org.basex.core.users.Perm;
import org.basex.data.Data;
import org.basex.data.DataClip;
import org.basex.data.MetaData;
import org.basex.index.resource.ResourceType;
import org.basex.io.IO;
import org.basex.io.IOFile;
import org.basex.query.up.atomic.AtomicUpdateCache;
import org.basex.util.list.IntList;

public final class Put
extends ACreate {
    private Add add;

    public Put(String path) {
        this(path, (String)null);
    }

    public Put(String path, String input) {
        super(Perm.WRITE, true, path, input);
    }

    @Override
    protected boolean run() {
        String path;
        if (this.in == null) {
            IO io = IO.get(this.args[1]);
            if (!io.exists()) {
                return this.error(Text.RES_NOT_FOUND_X, io);
            }
            this.in = io.inputSource();
        }
        if ((path = MetaData.normPath(this.args[0])) == null) {
            return this.error(Text.PATH_INVALID_X, this.args[0]);
        }
        Data data = this.context.data();
        IOFile bin = data.meta.file(path, ResourceType.BINARY);
        return this.update(data, () -> this.put(data, bin, path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean put(Data data, IOFile bin, String path) {
        this.context.invalidate();
        AtomicUpdateCache auc = new AtomicUpdateCache(data);
        IntList docs = data.resources.docs(path);
        int ds = docs.size();
        IntConsumer exec = start -> {
            for (int d = start; d < ds; ++d) {
                auc.addDelete(docs.get(d));
            }
            auc.execute(false);
        };
        int bs = 0;
        if (bin != null && bin.exists()) {
            BinaryPut put = new BinaryPut(path);
            put.setInput(this.in);
            put.lock = false;
            if (!put.run(this.context)) {
                return this.error(put.info(), new Object[0]);
            }
            bs = 1;
            exec.accept(0);
        } else {
            this.add = new Add(path);
            try {
                this.add.setInput(this.in);
                this.add.init(this.context, this.out);
                if (!this.add.build()) {
                    boolean put = this.error(this.add.info(), new Object[0]);
                    return put;
                }
                DataClip clip = new DataClip(this.add.tmpData);
                int d = 0;
                if (docs.isEmpty()) {
                    auc.addInsert(data.meta.size, -1, clip);
                } else {
                    auc.addReplace(docs.get(d++), clip);
                }
                exec.accept(d);
            }
            finally {
                this.add.finish();
            }
        }
        return this.info(Text.RES_REPLACED_X_X, ds + bs, this.jc().performance);
    }

    @Override
    public void build(CmdBuilder cb) {
        cb.init().arg(0).add(1);
    }

    @Override
    public String shortInfo() {
        return Text.PUT + "...";
    }

    @Override
    public double progressInfo() {
        Builder builder = this.add != null ? this.add.builder : null;
        return builder != null ? builder.progressInfo() : 0.0;
    }
}

