/*
 * Decompiled with CFR 0.152.
 */
package org.basex.index.path;

import java.io.IOException;
import java.util.ArrayList;
import org.basex.core.Text;
import org.basex.data.Data;
import org.basex.data.DataText;
import org.basex.data.MetaData;
import org.basex.index.stats.Stats;
import org.basex.io.in.DataInput;
import org.basex.io.out.DataOutput;
import org.basex.util.Array;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;

public final class PathNode {
    public final short name;
    public final byte kind;
    public final PathNode parent;
    public PathNode[] children;
    public final Stats stats;
    private byte empty;

    PathNode() {
        this(0, 0, null);
    }

    private PathNode(int name, byte kind, PathNode parent) {
        this.children = new PathNode[0];
        this.name = (short)name;
        this.kind = kind;
        this.parent = parent;
        this.stats = new Stats();
    }

    PathNode(DataInput in, PathNode node) throws IOException {
        this.name = (short)in.readNum();
        this.kind = (byte)in.read();
        in.readNum();
        int cl = in.readNum();
        in.readDouble();
        this.children = new PathNode[cl];
        this.stats = new Stats(in);
        this.parent = node;
        for (int c = 0; c < cl; ++c) {
            this.children[c] = new PathNode(in, this);
        }
    }

    PathNode index(int id, byte knd, byte[] value, MetaData meta) {
        for (PathNode child : this.children) {
            if (child.kind != knd || child.name != id) continue;
            child.index(value, meta);
            return child;
        }
        PathNode child = new PathNode(id, knd, this);
        child.index(value, meta);
        int cl = this.children.length;
        PathNode[] nodes = new PathNode[cl + 1];
        Array.copy(this.children, cl, nodes);
        nodes[cl] = child;
        this.children = nodes;
        return child;
    }

    private void index(byte[] value, MetaData meta) {
        if (value == null) {
            if (this.kind == 1) {
                if (this.empty == 0) {
                    this.empty = 1;
                } else if (this.empty == 1) {
                    this.empty = (byte)2;
                }
            }
        } else {
            this.stats.add(value, meta);
            if (this.kind == 2 && this.parent.empty == 1) {
                this.parent.empty = 0;
            }
        }
        ++this.stats.count;
    }

    void write(DataOutput out, MetaData meta) throws IOException {
        out.writeNum(this.name);
        out.write1(this.kind);
        out.writeNum(0);
        out.writeNum(this.children.length);
        out.writeDouble(1.0);
        boolean leaf = this.stats.isLeaf();
        for (PathNode child : this.children) {
            if (child.kind == 2) {
                if (this.empty == 0) continue;
                child.stats.add(Token.EMPTY, meta);
                continue;
            }
            if (child.kind == 3) continue;
            leaf = false;
        }
        this.stats.setLeaf(leaf);
        this.stats.write(out);
        for (PathNode child : this.children) {
            child.write(out, meta);
        }
    }

    void addDesc(ArrayList<PathNode> nodes) {
        nodes.add(this);
        for (PathNode child : this.children) {
            child.addDesc(nodes);
        }
    }

    void addDesc(ArrayList<PathNode> nodes, int nm) {
        if (this.kind == 1 && nm == this.name) {
            nodes.add(this);
        }
        for (PathNode child : this.children) {
            child.addDesc(nodes, nm);
        }
    }

    public byte[] token(Data data) {
        return switch (this.kind) {
            case 1 -> data.elemNames.key(this.name);
            case 3 -> Token.concat(DataText.ATT, data.attrNames.key(this.name));
            case 2 -> DataText.TEXT;
            case 4 -> DataText.COMMENT;
            case 5 -> DataText.PI;
            default -> Token.EMPTY;
        };
    }

    public int level() {
        PathNode pn = this.parent;
        int c = 0;
        while (pn != null) {
            pn = pn.parent;
            ++c;
        }
        return c;
    }

    byte[] info(Data data, int level) {
        TokenBuilder tb = new TokenBuilder();
        if (level != 0) {
            tb.add(Text.NL);
        }
        for (int i = 0; i < level << 1; ++i) {
            tb.add(32);
        }
        tb.add(this.kind == 0 ? DataText.DOC : this.token(data)).add(": " + String.valueOf(this.stats));
        for (PathNode p : this.children) {
            tb.add(p.info(data, level + 1));
        }
        return tb.finish();
    }

    public String toString() {
        return Util.className(this) + "[" + this.name + ":" + this.kind + "]";
    }
}

