/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.user;

import java.util.ArrayList;
import org.basex.core.Databases;
import org.basex.core.users.Perm;
import org.basex.core.users.User;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.Iter;
import org.basex.query.util.ASTVisitor;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.seq.Empty;
import org.basex.server.ClientListener;
import org.basex.util.Enums;
import org.basex.util.list.StringList;

abstract class UserFn
extends StandardFunc {
    static final QNm Q_INFO = new QNm("info");

    UserFn() {
    }

    protected final StringList toPatterns(Expr expr, QueryContext qc) throws QueryException {
        StringList patterns = new StringList();
        if (expr != Empty.UNDEFINED) {
            Item item;
            Iter iter = expr.iter(qc);
            while ((item = qc.next(iter)) != null) {
                String pattern = this.toString(item);
                if (!pattern.isEmpty() && !Databases.validPattern(pattern)) {
                    throw QueryError.USER_PATTERN_X.get(this.info, pattern);
                }
                patterns.add(pattern);
            }
        } else {
            patterns.add("");
        }
        return patterns;
    }

    protected final String toName(Expr expr, QueryContext qc) throws QueryException {
        return this.toName(expr, false, QueryError.USER_NAME_X, qc);
    }

    protected final User toUser(Expr expr, QueryContext qc) throws QueryException {
        User user;
        String name = this.toName(expr, qc);
        if (!qc.user.name().equals(name)) {
            this.checkPerm(qc, Perm.ADMIN);
        }
        if ((user = qc.context.users.get(name)) == null) {
            throw QueryError.USER_UNKNOWN_X.get(this.info, name);
        }
        return user;
    }

    protected final ArrayList<Perm> toPermissions(Expr expr, QueryContext qc) throws QueryException {
        ArrayList<Perm> perms = new ArrayList<Perm>();
        if (expr != Empty.UNDEFINED) {
            Item item;
            Iter iter = expr.iter(qc);
            while ((item = qc.next(iter)) != null) {
                String perm = this.toString(item);
                Perm p = Enums.get(Perm.class, perm);
                if (p == null) {
                    throw QueryError.USER_PERMISSION_X.get(this.info, perm);
                }
                perms.add(p);
            }
        } else {
            perms.add(Perm.NONE);
        }
        return perms;
    }

    protected final String toInactiveName(Expr expr, QueryContext qc) throws QueryException {
        String name = this.toName(expr, qc);
        this.toInactiveUser(qc.context.users.get(name), qc);
        return name;
    }

    protected final User toInactiveUser(Expr expr, QueryContext qc) throws QueryException {
        return this.toInactiveUser(this.toUser(expr, qc), qc);
    }

    private User toInactiveUser(User user, QueryContext qc) throws QueryException {
        if (user != null) {
            String name = user.name();
            for (ClientListener cl : qc.context.sessions) {
                if (!cl.context().user().name().equals(name)) continue;
                throw QueryError.USER_LOGGEDIN_X.get(this.info, name);
            }
        }
        return user;
    }

    @Override
    public final boolean accept(ASTVisitor visitor) {
        return (!this.hasUPD() || visitor.lock("internal:user")) && super.accept(visitor);
    }
}

