/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import java.util.Arrays;
import java.util.function.Predicate;
import org.basex.query.CompileContext;
import org.basex.query.InlineContext;
import org.basex.query.QueryBiFunction;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryFocus;
import org.basex.query.QueryFunction;
import org.basex.query.QueryString;
import org.basex.query.QuerySupplier;
import org.basex.query.expr.And;
import org.basex.query.expr.Arr;
import org.basex.query.expr.Cmp;
import org.basex.query.expr.CmpG;
import org.basex.query.expr.CmpV;
import org.basex.query.expr.ContextValue;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Filter;
import org.basex.query.expr.Instance;
import org.basex.query.expr.IntPos;
import org.basex.query.expr.ParseExpr;
import org.basex.query.expr.Pos;
import org.basex.query.expr.SimpleMap;
import org.basex.query.expr.SimplePos;
import org.basex.query.expr.StructFilter;
import org.basex.query.expr.ft.FTContains;
import org.basex.query.expr.ft.FTExpr;
import org.basex.query.expr.path.Axis;
import org.basex.query.expr.path.Path;
import org.basex.query.expr.path.SingleIterPath;
import org.basex.query.expr.path.Step;
import org.basex.query.expr.path.Test;
import org.basex.query.func.Function;
import org.basex.query.func.fn.FnError;
import org.basex.query.util.Flag;
import org.basex.query.util.list.ExprList;
import org.basex.query.value.Value;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Item;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;

public abstract class Preds
extends Arr {
    protected Preds(InputInfo info, SeqType seqType, Expr ... preds) {
        super(info, seqType, preds);
    }

    @Override
    public Expr compile(CompileContext cc) throws QueryException {
        Expr root = this.type(cc.qc.focus.value, false);
        int el = this.exprs.length;
        boolean value = this instanceof StructFilter;
        if (el != 0) {
            cc.get(value ? null : this, !value, () -> {
                long size;
                if (root != null && (size = root.size()) != -1L) {
                    cc.qc.focus.size = size;
                }
                for (int e = 0; e < el; ++e) {
                    this.exprs[e] = cc.compileOrError(this.exprs[e], false);
                    cc.qc.focus.size = 1L;
                }
                return null;
            });
        }
        return this.optimize(cc);
    }

    protected abstract Expr type(Expr var1, boolean var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean test(Item item, QueryContext qc) throws QueryException {
        QueryFocus qf = qc.focus;
        Value qv = qf.value;
        qf.value = item;
        try {
            for (Expr expr : this.exprs) {
                if (expr.test(qc, this.info, qf.pos)) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            qf.value = qv;
        }
    }

    protected final boolean optimize(CompileContext cc, Expr root) throws QueryException {
        return cc.ok(root, true, () -> {
            ExprList list = new ExprList(this.exprs.length);
            for (Expr expr : this.exprs) {
                this.optimize(expr, list, root, cc);
            }
            this.exprs = (Expr[])list.finish();
            return this.optimizeEbv(false, true, cc);
        }) || this.optimizeType(root);
    }

    private void optimize(Expr pred, ExprList list, Expr root, CompileContext cc) throws QueryException {
        Expr ex;
        Path path;
        Expr expr = pred.simplifyFor(CompileContext.Simplify.PREDICATE, cc);
        SeqType rst = root.seqType();
        Predicate<Expr> first = f -> f instanceof ContextValue || root.equals(f) && root.isSimple() && rst.one();
        if (expr instanceof SimpleMap) {
            SimpleMap sm = (SimpleMap)expr;
            if (first.test(expr.arg(0)) && !expr.arg(1).has(Flag.POS)) {
                expr = sm.remove(cc, 0);
            }
        }
        if (expr instanceof Path) {
            path = (Path)expr;
            if (rst.type instanceof NodeType && first.test(path.root) && !path.steps[0].has(Flag.POS)) {
                expr = Path.get(cc, expr.info(this.info), null, path.steps);
            }
        }
        if (root instanceof Item && !(rst.type instanceof NodeType)) {
            try {
                expr = new InlineContext(null, root, cc).inline(expr);
            }
            catch (QueryException ex2) {
                expr = FnError.get(ex2, expr);
            }
        }
        if (expr instanceof SingleIterPath) {
            path = (SingleIterPath)expr;
            Step predStep = (Step)((SingleIterPath)path).steps[0];
            if (predStep.axis == Axis.SELF && !predStep.mayBePositional() && root instanceof Step) {
                Test test;
                Step rootStep = (Step)root;
                if (!this.mayBePositional() && (test = rootStep.test.intersect(predStep.test)) != null) {
                    cc.info("merge: %", predStep);
                    rootStep.test = test;
                    rootStep.exprType.assign(Step.seqType(rootStep.axis, rootStep.test, rootStep.exprs));
                    list.add(predStep.exprs);
                    expr = Bln.TRUE;
                }
            }
        }
        if (expr.seqType().type.instanceOf(AtomType.NUMERIC) && (ex = Pos.get(expr, CmpV.OpV.EQ, this.info, cc, null)) != null) {
            expr = ex;
        }
        if (root instanceof Step) {
            Step step = (Step)root;
            Axis axis = step.axis;
            if ((axis == Axis.SELF || axis == Axis.PARENT) && expr instanceof IntPos) {
                IntPos pos = (IntPos)expr;
                expr = Bln.get(pos.min == 1L);
            }
        }
        if (expr instanceof And && !expr.has(Flag.POS)) {
            cc.info("rewrite to predicate: %", expr);
            for (Expr arg : expr.args()) {
                boolean numeric = arg.seqType().mayBeNumber();
                this.optimize(numeric ? cc.function(Function.BOOLEAN, this.info, arg) : arg, list, root, cc);
            }
            expr = Bln.TRUE;
        }
        if (expr != Bln.TRUE) {
            list.add(cc.simplify(pred, expr, CompileContext.Simplify.PREDICATE));
        }
    }

    /*
     * Unable to fully structure code
     */
    private boolean optimizeType(Expr root) {
        max = root.size();
        v0 = exact = max != -1L;
        if (!exact) {
            max = 0x7FFFFFFFFFFFFFFFL;
        }
        for (Expr expr : this.exprs) {
            block8: {
                if (!(expr instanceof Pos)) break block8;
                pos = (Pos)expr;
                if (Function.LAST.is(pos.expr)) ** GOTO lbl-1000
            }
            if (expr instanceof SimplePos && (ss = (SimplePos)expr).exact() && Function.LAST.is(ss.arg(0))) lbl-1000:
            // 2 sources

            {
                max = Math.min(max, 1L);
            } else if (expr instanceof IntPos) {
                pos = (IntPos)expr;
                if (max != 0x7FFFFFFFFFFFFFFFL) {
                    max = Math.max(0L, max - pos.min + 1L);
                }
                max = Math.min(max, pos.max - pos.min + 1L);
            } else {
                exact = false;
            }
            if (max != 0L) continue;
            return true;
        }
        st = root.seqType();
        for (Expr expr : this.exprs) {
            if (!(expr instanceof Instance) || !((inst = (Instance)expr).arg(0) instanceof ContextValue) || (st = st.intersect(inst.seqType.with(st.occ))) != null) continue;
            return true;
        }
        this.exprType.assign(max == 1L ? st.with(Occ.ZERO_OR_ONE) : st.union(Occ.ZERO), exact != false ? max : -1L);
        return false;
    }

    public final Expr flattenEbv(Expr root, boolean ebv, CompileContext cc) throws QueryException {
        ParseExpr cmp;
        SeqType rst = root.seqType();
        int el = this.exprs.length;
        if (el == 0 || this.mayBePositional()) {
            return this;
        }
        Expr last = this.exprs[el - 1];
        QuerySupplier<Expr> createRoot = () -> {
            Expr expr;
            if (root instanceof Path) {
                Path path = (Path)root;
                expr = path.removePredicate(cc);
            } else {
                expr = el > 1 ? Filter.get(cc, this.info, root, Arrays.copyOfRange(this.exprs, 0, el - 1)) : root;
            }
            return expr;
        };
        QueryFunction<Expr, Expr> createSimpleMap = rhs -> SimpleMap.get(cc, this.info, (Expr)createRoot.get(), rhs);
        QueryBiFunction<Expr, Boolean, Expr> createExpr = (rhs, compare) -> rhs instanceof ContextValue ? (Expr)createRoot.get() : (rhs instanceof Path ? Path.get(cc, this.info, (Expr)createRoot.get(), rhs) : (compare != false ? (Expr)createSimpleMap.apply((Expr)rhs) : this));
        if (rst.type instanceof NodeType) {
            Expr expr = createExpr.apply(last, false);
            if (expr != this) {
                return expr;
            }
        } else if (ebv) {
            return this;
        }
        if (last instanceof Cmp) {
            Expr expr;
            cmp = (Cmp)last;
            Expr op1 = ((Cmp)cmp).exprs[0];
            Expr op2 = ((Cmp)cmp).exprs[1];
            SeqType st1 = op1.seqType();
            SeqType st2 = op2.seqType();
            Type type1 = st1.type;
            Type type2 = st2.type;
            if ((cmp instanceof CmpG || cmp instanceof CmpV && st1.zeroOrOne() && st2.zeroOrOne() && (type1 == type2 || type1.isStringOrUntyped() && type2.isStringOrUntyped())) && !op2.has(Flag.CTX) && (expr = createExpr.apply(op1, true)) != this) {
                return new CmpG(((Cmp)cmp).info, expr, op2, ((Cmp)cmp).opG()).optimize(cc);
            }
        }
        if (last instanceof FTContains) {
            Expr expr;
            cmp = (FTContains)last;
            FTExpr ftexpr = ((FTContains)cmp).ftexpr;
            if (!ftexpr.has(Flag.CTX) && (expr = createExpr.apply(((FTContains)cmp).expr, true)) != this) {
                return new FTContains(expr, ftexpr, ((FTContains)cmp).info).optimize(cc);
            }
        }
        if (rst.zeroOrOne()) {
            return createSimpleMap.apply(last);
        }
        return this;
    }

    public boolean mayBePositional() {
        for (Expr expr : this.exprs) {
            if (!Preds.mayBePositional(expr)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean inlineable(InlineContext ic) {
        if (ic.var != null && ic.expr.has(Flag.CTX)) {
            for (Expr expr : this.exprs) {
                if (!expr.uses(ic.var)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void toString(QueryString qs) {
        for (Expr expr : this.exprs) {
            qs.braced("[", expr, "]");
        }
    }
}

