/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import java.util.Arrays;
import java.util.function.Predicate;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryString;
import org.basex.query.expr.Arith;
import org.basex.query.expr.Arr;
import org.basex.query.expr.Calc;
import org.basex.query.expr.CmpV;
import org.basex.query.expr.Expr;
import org.basex.query.func.Function;
import org.basex.query.util.Flag;
import org.basex.query.value.Value;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Itr;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.RangeSeq;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Types;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjectMap;

public final class Range
extends Arr {
    private static final long LAST = 0x10000000000000L;

    public Range(InputInfo info, Expr ... range) {
        super(info, Types.INTEGER_ZM, range);
    }

    @Override
    public Expr optimize(CompileContext cc) throws QueryException {
        this.exprs = this.simplifyAll(CompileContext.Simplify.NUMBER, cc);
        Expr expr = this.emptyExpr();
        if (expr == this) {
            if (this.values(false, cc)) {
                return cc.preEval(this);
            }
            Expr min = this.exprs[0];
            Expr max = this.exprs[1];
            if (!min.has(Flag.NDT)) {
                if (min.equals(max)) {
                    this.exprType.assign(Occ.EXACTLY_ONE);
                    if (this.integers()) {
                        expr = min;
                    }
                } else if (max instanceof Arith) {
                    Expr expr2;
                    Arith arith = (Arith)max;
                    if (min.equals(max.arg(0)) && arith.calc.oneOf(Calc.ADD, Calc.SUBTRACT) && (expr2 = arith.arg(1)) instanceof Itr) {
                        Itr itr = (Itr)expr2;
                        long n = (arith.calc == Calc.ADD ? itr.itr() : -itr.itr()) + 1L;
                        if (n < 1L) {
                            expr = Empty.VALUE;
                        } else {
                            this.exprType.assign(this.seqType(), n);
                        }
                    }
                }
            }
        }
        return cc.replaceWith(this, expr);
    }

    boolean integers() {
        SeqType st1 = this.exprs[0].seqType();
        SeqType st2 = this.exprs[1].seqType();
        return st1.instanceOf(Types.INTEGER_O) && st2.instanceOf(Types.INTEGER_O);
    }

    @Override
    public Value value(QueryContext qc) throws QueryException {
        long mx;
        Item min = this.exprs[0].atomItem(qc, this.info);
        if (min.isEmpty()) {
            return Empty.VALUE;
        }
        Item max = this.exprs[1].atomItem(qc, this.info);
        if (max.isEmpty()) {
            return Empty.VALUE;
        }
        long mn = this.toLong(min);
        if (mn > (mx = this.toLong(max))) {
            return Empty.VALUE;
        }
        long size = mx - mn + 1L;
        return RangeSeq.get(mn, size < 0L ? Long.MAX_VALUE : size, true);
    }

    @Override
    public Range copy(CompileContext cc, IntObjectMap<Var> vm) {
        return this.copyType(new Range(this.info, Range.copyAll((CompileContext)cc, vm, (Expr[])this.exprs)));
    }

    @Override
    public Expr optimizePos(CmpV.OpV op, CompileContext cc) throws QueryException {
        Predicate<Expr> type = e -> {
            SeqType st = e.seqType();
            return st.one() && (st.type.instanceOf(AtomType.INTEGER) || st.type.isUntyped());
        };
        if (!type.test(this.exprs[0]) || !type.test(this.exprs[1])) {
            return this;
        }
        Object[] minMax = (Expr[])this.exprs.clone();
        double mn = Range.pos(minMax[0]);
        double mx = Range.pos(minMax[1]);
        if (mx < mn) {
            return Bln.FALSE;
        }
        boolean results = mn <= mx;
        switch (op) {
            case EQ: {
                if (mn <= 1.0 && mx >= 4.503599627370496E15) {
                    return Bln.TRUE;
                }
                if (mn > 4.503599627370496E15 || mx < 1.0) {
                    return Bln.FALSE;
                }
                if (mn < 1.0) {
                    minMax[0] = Itr.ONE;
                }
                if (mn == 4.503599627370496E15 && mx > mn) {
                    minMax[1] = cc.function(Function.LAST, this.info, new Expr[0]);
                }
                if (!(mn < 4.503599627370496E15) || !(mx >= 4.503599627370496E15)) break;
                minMax[1] = Itr.MAX;
                break;
            }
            case NE: {
                if (mn <= 1.0 && mx >= 4.503599627370496E15) {
                    return Bln.FALSE;
                }
                if (results && (mn > 4.503599627370496E15 || mx < 1.0)) {
                    return Bln.TRUE;
                }
                if (mn < 1.0) {
                    minMax[0] = Itr.ONE;
                }
                if (mn == 4.503599627370496E15 && mx > mn) {
                    minMax[1] = cc.function(Function.LAST, this.info, new Expr[0]);
                }
                if (!(mn < 4.503599627370496E15) || !(mx >= 4.503599627370496E15)) break;
                minMax[1] = Itr.MAX;
                break;
            }
            case LE: {
                if (mx < 1.0) {
                    return Bln.FALSE;
                }
                if (results && mx >= 4.503599627370496E15) {
                    return Bln.TRUE;
                }
                if (!(mn < 1.0)) break;
                minMax[0] = Itr.ONE;
                break;
            }
            case LT: {
                if (mx <= 1.0) {
                    return Bln.FALSE;
                }
                if (!results || !(mx > 4.503599627370496E15)) break;
                return Bln.TRUE;
            }
            case GE: {
                if (mn > 4.503599627370496E15) {
                    return Bln.FALSE;
                }
                if (!results || !(mx <= 1.0)) break;
                return Bln.TRUE;
            }
            case GT: {
                if (mn >= 4.503599627370496E15) {
                    return Bln.FALSE;
                }
                if (!results || !(mx < 1.0)) break;
                return Bln.TRUE;
            }
        }
        if (Arrays.equals(this.exprs, minMax)) {
            return this;
        }
        Expr ex = new Range(this.info, (Expr[])minMax).optimize(cc);
        return ex == Empty.VALUE ? Bln.FALSE : ex;
    }

    private static double pos(Expr expr) {
        if (expr instanceof Itr) {
            Itr itr = (Itr)expr;
            return itr.itr();
        }
        if (Function.LAST.is(expr)) {
            return 4.503599627370496E15;
        }
        if (expr instanceof Arith) {
            Arith arth = (Arith)expr;
            if (Function.LAST.is(expr.arg(0))) {
                double l;
                Expr expr2 = expr.arg(1);
                if (expr2 instanceof Itr) {
                    Itr itr = (Itr)expr2;
                    v0 = itr.itr();
                } else {
                    v0 = l = 0.0;
                }
                if (l != 0.0) {
                    return switch (arth.calc) {
                        case Calc.ADD -> 4.503599627370496E15 + l;
                        case Calc.SUBTRACT -> 4.503599627370496E15 - l;
                        case Calc.MULTIPLY -> 4.503599627370496E15 * l;
                        case Calc.DIVIDE -> 4.503599627370496E15 / l;
                        default -> Double.NaN;
                    };
                }
            }
        }
        return Double.NaN;
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof Range && super.equals(obj);
    }

    @Override
    public String description() {
        return "range expression";
    }

    @Override
    public void toString(QueryString qs) {
        qs.tokens(this.exprs, " to ", true);
    }
}

