/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.file;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Random;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.func.file.FileFn;
import org.basex.query.value.Value;
import org.basex.query.value.item.Str;
import org.basex.util.Prop;

public class FileCreateTempFile
extends FileFn {
    @Override
    public Value eval(QueryContext qc) throws QueryException, IOException {
        return this.createTemp(false, qc);
    }

    final Str createTemp(boolean directory, QueryContext qc) throws QueryException, IOException {
        StringBuilder path;
        Path file;
        Path root;
        String prefix = this.toStringOrNull(this.arg(0), qc);
        String suffix = this.toStringOrNull(this.arg(1), qc);
        String dir = this.toStringOrNull(this.arg(2), qc);
        Path path2 = root = dir != null ? this.toPath(dir) : Paths.get(Prop.TEMPDIR, new String[0]);
        if (Files.isRegularFile(root, new LinkOption[0])) {
            throw QueryError.FILE_NO_DIR_X.get(this.info, root);
        }
        Random rnd = new Random();
        do {
            path = new StringBuilder();
            if (prefix != null) {
                path.append(prefix);
            }
            path.append(rnd.nextLong());
            if (suffix == null) continue;
            path.append(suffix);
        } while (Files.exists(file = root.resolve(path.toString()), new LinkOption[0]));
        if (directory) {
            Files.createDirectory(file, new FileAttribute[0]);
        } else {
            Files.createFile(file, new FileAttribute[0]);
        }
        return FileCreateTempFile.get(file, directory);
    }
}

