/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.item;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import org.basex.io.out.DataOutput;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryString;
import org.basex.query.StaticContext;
import org.basex.query.util.DeepEqual;
import org.basex.query.util.DeepEqualOptions;
import org.basex.query.util.NSGlobal;
import org.basex.query.util.collation.Collation;
import org.basex.query.value.item.Item;
import org.basex.query.value.type.AtomType;
import org.basex.util.Array;
import org.basex.util.InputInfo;
import org.basex.util.Strings;
import org.basex.util.Token;
import org.basex.util.XMLToken;
import org.basex.util.list.ByteList;

public final class QNm
extends Item {
    public static final QNm EMPTY = new QNm(Token.EMPTY);
    private static final Pattern EQNAME = Pattern.compile("^Q\\{([^{}]*)\\}(.+)$");
    private final byte[] name;
    private final int prefix;
    private byte[] uri;

    public QNm(byte[] name) {
        super(AtomType.QNAME);
        this.name = name;
        this.prefix = Token.indexOf(name, 58);
    }

    public QNm(String name) {
        this(Token.token(name));
    }

    public QNm(byte[] name, byte[] uri) {
        this(name);
        this.uri(uri);
    }

    public QNm(String name, byte[] uri) {
        this(Token.token(name), uri);
    }

    public QNm(String name, String uri) {
        this(Token.token(name), uri == null ? null : Token.token(uri));
    }

    public QNm(byte[] prefix, String local, byte[] uri) {
        this(prefix, Token.token(local), uri);
    }

    public QNm(byte[] prefix, byte[] local, byte[] uri) {
        this(prefix.length > 0 ? Token.concat(prefix, Token.cpToken(58), Token.token(local)) : local, uri);
    }

    public QNm(byte[] name, StaticContext sc) {
        this(name);
        this.uri(sc.ns.uri(this.prefix()));
    }

    public QNm(QName name) {
        this(Token.token(name.getPrefix().isEmpty() ? name.getLocalPart() : (Object)Token.concat(name.getPrefix(), Token.cpToken(58), name.getLocalPart())), Token.token(name.getNamespaceURI()));
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeToken(this.name);
        out.writeBool(this.uri != null);
        if (this.uri != null) {
            out.writeToken(this.uri);
        }
    }

    public void uri(byte[] u) {
        this.uri = u == null ? null : Token.normalize(u);
    }

    public byte[] uri() {
        return this.uri == null ? Token.EMPTY : this.uri;
    }

    public boolean hasURI() {
        return this.uri != null;
    }

    @Override
    public byte[] string(InputInfo ii) {
        return this.name;
    }

    public byte[] string() {
        return this.name;
    }

    @Override
    public boolean deepEqual(Item item, DeepEqual deep) throws QueryException {
        return this.type == item.type && this.equal(item, null, deep.info) && (deep.options.get(DeepEqualOptions.NAMESPACE_PREFIXES) == false || Token.eq(this.prefix(), ((QNm)item).prefix()));
    }

    public boolean eq(QNm qnm) {
        if (qnm == this) {
            return true;
        }
        return this.uri == null && qnm.uri == null ? Token.eq(this.name, qnm.name) : Token.eq(this.uri(), qnm.uri()) && Token.eq(this.local(), qnm.local());
    }

    @Override
    public int compare(Item item, Collation coll, boolean transitive, InputInfo ii) throws QueryException {
        QNm qnm;
        StaticContext sc;
        StaticContext staticContext = sc = ii != null ? ii.sc() : null;
        if (item instanceof QNm) {
            QNm q;
            qnm = q = (QNm)item;
        } else if (item.type.isUntyped() && sc != null) {
            byte[] nm = Token.trim(item.string(ii));
            if (!XMLToken.isQName(nm)) {
                throw QueryError.FUNCCAST_X_X_X.get(ii, item.type, this.type, item);
            }
            qnm = new QNm(nm, sc);
            if (!qnm.hasURI() && qnm.hasPrefix()) {
                throw QueryError.NSDECL_X.get(ii, new Object[]{qnm.prefix()});
            }
        } else {
            throw QueryError.compareError(this, item, ii);
        }
        int c = Token.compare(this.uri(), qnm.uri());
        return c != 0 ? c : Token.compare(this.local(), qnm.local());
    }

    public boolean hasPrefix() {
        return this.prefix != -1;
    }

    public byte[] prefix() {
        return this.prefix == -1 ? Token.EMPTY : Token.substring(this.name, 0, this.prefix);
    }

    public byte[] local() {
        return this.prefix == -1 ? this.name : Token.substring(this.name, this.prefix + 1);
    }

    public byte[] unique() {
        return this.uri == null ? this.name : QNm.internal(null, this.local(), this.uri);
    }

    public byte[] eqName() {
        return QNm.eqName(this.uri(), this.local());
    }

    public byte[] prefixId() {
        return this.prefixId(null);
    }

    public byte[] prefixId(byte[] ns) {
        byte[] u = this.uri();
        if (ns != null && Token.eq(u, ns)) {
            return this.local();
        }
        byte[] p = NSGlobal.prefix(u);
        return p.length != 0 ? Token.concat(p, Token.cpToken(58), this.local()) : this.unique();
    }

    public byte[] prefixString() {
        return this.hasPrefix() ? this.string() : this.prefixId();
    }

    public byte[] varString() {
        return Token.concat("$", this.string());
    }

    @Override
    public QName toJava() {
        return new QName(Token.string(this.uri()), Token.string(this.local()), Token.string(this.prefix()));
    }

    public int hashCode() {
        return Token.hashCode(this.unique());
    }

    @Override
    public byte[] xdmInfo() {
        return new ByteList().add(this.typeId().asByte()).add(this.uri()).add(0).finish();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof QNm)) return false;
        QNm qnm = (QNm)obj;
        if (!Token.eq(this.uri(), qnm.uri())) return false;
        if (!Token.eq(this.name, qnm.name)) return false;
        return true;
    }

    @Override
    public void toString(QueryString qs) {
        qs.token(Token.concat(Character.valueOf('#'), this.unique()));
    }

    public static QNm parse(byte[] value, StaticContext sc) throws QueryException {
        return QNm.parse(value, null, sc, null);
    }

    public static QNm parse(byte[] value, byte[] dflt, StaticContext sc, InputInfo info) throws QueryException {
        byte[][] parsed = QNm.parseExpanded(value, false);
        if (parsed != null) {
            return new QNm(parsed[0], parsed[1]);
        }
        byte[] uri = null;
        int i = Token.indexOf(value, 58);
        if (i == -1) {
            uri = dflt;
        } else {
            byte[] prefix = Token.substring(value, 0, i);
            if (sc != null) {
                uri = sc.ns.uri(prefix);
            }
            if (uri == null) {
                throw QueryError.NOURI_X.get(info, new Object[]{prefix});
            }
        }
        if (XMLToken.isQName(value)) {
            return new QNm(value, uri);
        }
        throw QueryError.INVNAME_X.get(info, new Object[]{value});
    }

    public static byte[][] parseExpanded(byte[] value, boolean wc) {
        Matcher matcher = EQNAME.matcher(Token.string(value));
        if (matcher.matches()) {
            byte[] uri = Token.token(matcher.group(1));
            byte[] name = Token.token(matcher.group(2));
            if (wc && Token.eq(name, Token.cpToken(42))) {
                return new byte[][]{null, uri};
            }
            if (XMLToken.isQName(name)) {
                return new byte[][]{name, uri};
            }
        }
        return null;
    }

    public static byte[] eqName(byte[] uri, byte[] local) {
        return Token.concat("Q{", uri, "}", local);
    }

    public static String eqName(String uri, String local) {
        return Strings.concat("Q{", uri, "}", local);
    }

    private static byte[] internal(byte[] prefix, byte[] local, byte[] uri) {
        int pl;
        int ul = uri == null ? 0 : uri.length;
        int n = pl = prefix == null ? 0 : prefix.length;
        if (ul == 0 && pl == 0) {
            return local;
        }
        int l = (ul == 0 ? 0 : ul + 3) + (pl == 0 ? 0 : pl + 1) + local.length;
        byte[] key = new byte[l];
        int i = 0;
        if (ul != 0) {
            key[i++] = 81;
            key[i++] = 123;
            Array.copyFromStart(uri, ul, key, i);
            key[i + ul] = 125;
            i += ul + 1;
        }
        if (pl != 0) {
            Array.copyFromStart(prefix, pl, key, i);
            key[i + pl] = 58;
            i += pl + 1;
        }
        Array.copyFromStart(local, local.length, key, i);
        return key;
    }
}

