/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.seq;

import java.io.IOException;
import java.util.Arrays;
import org.basex.io.in.DataInput;
import org.basex.io.out.DataOutput;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.value.Value;
import org.basex.query.value.item.Bln;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.NativeSeq;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.Type;

public final class BlnSeq
extends NativeSeq {
    private static final BlnSeq FT = new BlnSeq(new boolean[]{false, true});
    private static final BlnSeq TF = new BlnSeq(new boolean[]{true, false});
    private final boolean[] values;

    private BlnSeq(boolean[] values) {
        super(values.length, (Type)AtomType.BOOLEAN);
        this.values = values;
    }

    public static Value read(DataInput in, Type type, QueryContext qc) throws IOException {
        int size = in.readNum();
        boolean[] values = new boolean[size];
        for (int s = 0; s < size; ++s) {
            values[s] = in.readBool();
        }
        return BlnSeq.get(values);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeNum((int)this.size);
        for (boolean v : this.values) {
            out.writeBool(v);
        }
    }

    @Override
    public Bln itemAt(long index) {
        return Bln.get(this.values[(int)index]);
    }

    @Override
    public Value reverse(QueryContext qc) {
        int sz = (int)this.size;
        boolean[] tmp = new boolean[sz];
        for (int i = 0; i < sz; ++i) {
            tmp[sz - i - 1] = this.values[i];
        }
        return BlnSeq.get(tmp);
    }

    @Override
    public Expr simplifyFor(CompileContext.Simplify mode, CompileContext cc) throws QueryException {
        BlnSeq expr = this;
        if (mode.oneOf(CompileContext.Simplify.DISTINCT, CompileContext.Simplify.PREDICATE) && this != FT && this != TF) {
            boolean f = false;
            boolean t = false;
            for (boolean b : this.values) {
                if (b) {
                    t = true;
                } else {
                    f = true;
                }
                if (!f || !t) continue;
                return this.values[0] ? TF : FT;
            }
            return Bln.get(t);
        }
        return cc.simplify(this, expr, mode);
    }

    public boolean[] toJava() {
        return this.values;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (obj instanceof BlnSeq) {
            BlnSeq seq = (BlnSeq)obj;
            if (!Arrays.equals(this.values, seq.values)) return false;
            return true;
        } else if (!super.equals(obj)) return false;
        return true;
    }

    public static Value get(boolean[] values) {
        int vl = values.length;
        return vl == 0 ? Empty.VALUE : (vl == 1 ? Bln.get(values[0]) : new BlnSeq(values));
    }
}

