/*
 * Decompiled with CFR 0.152.
 */
package net.xqj.core;

import java.util.Enumeration;
import java.util.Properties;
import net.xqj.core.TextContainer;
import org.xml.sax.Attributes;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public class SAX2CharArray
extends DefaultHandler
implements LexicalHandler {
    private Properties namespaces = new Properties();
    private boolean hasContents = false;
    private boolean isFirstElement = true;
    private final TextContainer text;
    private static final char[] SPACE_XMLNS = new char[]{' ', 'x', 'm', 'l', 'n', 's'};
    private static final char[] SPACE_XMLNS_EQ = new char[]{' ', 'x', 'm', 'l', 'n', 's', '='};
    private static final char[] PROC_INST_START = new char[]{'<', '?', ' '};
    private static final char[] PROC_INST_END = new char[]{'?', '>'};
    private static final char[] COMMENT_START = new char[]{'<', '!', '-', '-'};
    private static final char[] COMMENT_END = new char[]{'-', '-', '>'};
    private static final char[] DOCTYPE_START = new char[]{'<', '!', 'D', 'O', 'C', 'T', 'Y', 'P', 'E', ' '};
    private static final char[] SYSTEM = new char[]{'S', 'Y', 'S', 'T', 'E', 'M'};
    private static final char[] PUBLIC = new char[]{'P', 'U', 'B', 'L', 'I', 'C', ' '};
    private static final char[] CDATA_START = new char[]{'<', '!', '[', 'C', 'D', 'A', 'T', 'A', '['};
    private static final char[] CDATA_END = new char[]{']', ']', '>'};
    private static final char[] AMP = new char[]{'&', 'a', 'm', 'p', ';'};
    private static final char[] LT = new char[]{'&', 'l', 't', ';'};
    private static final char[] GT = new char[]{'&', 'g', 't', ';'};
    private static final char[] QUOT = new char[]{'&', 'q', 'u', 'o', 't'};
    private static final char[] APOS = new char[]{'&', 'a', 'p', 'o', 's', ';'};
    private static final char[] XML_END_1 = new char[]{'/', '>'};
    private static final char[] XML_END_2 = new char[]{'<', '/'};

    public SAX2CharArray(TextContainer text) {
        this.text = text;
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (!this.hasContents) {
            this.text.append('>');
            this.hasContents = true;
        }
        this.serializeText(ch, start, length);
    }

    public void serializeText(char[] ch, int start, int length) {
        block7: for (int i = 0; i < length; ++i) {
            char c = ch[start + i];
            switch (c) {
                case '&': {
                    this.text.append(AMP, 5);
                    continue block7;
                }
                case '<': {
                    this.text.append(LT, 4);
                    continue block7;
                }
                case '>': {
                    this.text.append(GT, 4);
                    continue block7;
                }
                case '\"': {
                    this.text.append(QUOT, 5);
                    continue block7;
                }
                case '\'': {
                    this.text.append(APOS, 6);
                    continue block7;
                }
                default: {
                    this.text.append(c);
                }
            }
        }
    }

    @Override
    public void endDocument() {
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        if (this.hasContents) {
            this.text.append(XML_END_2, 2);
            this.text.append(qName.toCharArray(), qName.length());
            this.text.append('>');
        } else {
            this.text.append(XML_END_1, 2);
            this.hasContents = true;
        }
    }

    @Override
    public void processingInstruction(String target, String data) {
        this.text.append(PROC_INST_START, 3);
        this.text.append(target.toCharArray(), target.length());
        this.text.append(' ');
        this.text.append(data.toCharArray(), data.length());
        this.text.append(PROC_INST_END, 2);
        this.hasContents = true;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) {
        if (!this.hasContents && !this.isFirstElement) {
            this.text.append('>');
        }
        this.text.append('<');
        this.text.append(qName.toCharArray(), qName.length());
        for (int i = atts.getLength() - 1; i >= 0; --i) {
            String qnameStr = atts.getQName(i);
            if (qnameStr.equals("xmlns")) continue;
            this.text.append(' ');
            this.text.append(qnameStr.toCharArray(), qnameStr.length());
            this.text.append('=');
            this.text.append('\"');
            char[] ch = atts.getValue(i).toCharArray();
            this.serializeText(ch, 0, ch.length);
            this.text.append('\"');
        }
        if (this.isFirstElement) {
            Enumeration<?> e = this.namespaces.propertyNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                this.text.append(SPACE_XMLNS, 6);
                if (name.length() != 0) {
                    this.text.append(':');
                    this.text.append(name.toCharArray(), name.length());
                }
                this.text.append('=');
                String quoted = SAX2CharArray.getInQuotes((String)this.namespaces.get(name));
                this.text.append(quoted.toCharArray(), quoted.length());
            }
            this.isFirstElement = false;
        } else if (this.getPrefixFromURI(uri) == null) {
            this.text.append(SPACE_XMLNS_EQ, 7);
            String quoted = SAX2CharArray.getInQuotes(uri);
            this.text.append(quoted.toCharArray(), quoted.length());
        }
        this.hasContents = false;
    }

    @Override
    public void comment(char[] ch, int start, int length) {
        this.text.append(COMMENT_START, 4);
        this.text.append(ch, start, length);
        this.text.append(COMMENT_END, 3);
    }

    @Override
    public void endCDATA() {
        this.text.append(CDATA_END, 3);
    }

    @Override
    public void endDTD() {
    }

    @Override
    public void endEntity(String name) {
    }

    @Override
    public void startCDATA() {
        this.text.append(CDATA_START, 9);
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) {
        char[] quoted;
        this.text.append(DOCTYPE_START, 10);
        this.text.append(name.toCharArray(), name.length());
        this.text.append(' ');
        if (publicId == null) {
            this.text.append(SYSTEM, 6);
        } else {
            this.text.append(PUBLIC, 7);
            quoted = SAX2CharArray.getInQuotes(publicId).toCharArray();
            this.text.append(quoted, quoted.length);
        }
        this.text.append(' ');
        quoted = SAX2CharArray.getInQuotes(systemId).toCharArray();
        this.text.append(quoted, quoted.length);
        this.text.append('>');
    }

    @Override
    public void startEntity(String name) {
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) {
        if (this.isFirstElement) {
            this.namespaces.put(prefix, uri);
        }
    }

    private String getPrefixFromURI(String uri) {
        Enumeration<?> e = this.namespaces.propertyNames();
        while (e.hasMoreElements()) {
            String prefix = (String)e.nextElement();
            String pUri = this.namespaces.getProperty(prefix);
            if (!pUri.equals(uri)) continue;
            return prefix;
        }
        return null;
    }

    public String toString() {
        return new String(this.text.getRawCharArray(), this.text.offset(), this.text.length());
    }

    public char[] toCharArray() {
        char[] niceBuffer = new char[this.text.length()];
        System.arraycopy(this.text.getRawCharArray(), this.text.offset(), niceBuffer, 0, this.text.length());
        return niceBuffer;
    }

    public char[] getBuffer() {
        return this.text.getRawCharArray();
    }

    public int getPosition() {
        return this.text.length();
    }

    public static final String getInQuotes(String string) {
        StringBuffer buffer = new StringBuffer();
        char quoteCharacter = '\"';
        if (string.indexOf(34) != -1) {
            quoteCharacter = '\'';
        }
        boolean replace = false;
        if (quoteCharacter == '\'' && string.indexOf(39) != -1) {
            quoteCharacter = '\"';
            replace = true;
        }
        buffer.append(quoteCharacter);
        if (replace) {
            int n;
            int fromIndex = 0;
            while ((n = string.indexOf(34, fromIndex)) != -1) {
                buffer.append(string.substring(fromIndex, n));
                buffer.append("\"\"");
                fromIndex = n + 1;
            }
            buffer.append(string.substring(fromIndex, string.length()));
        } else {
            buffer.append(string);
        }
        buffer.append(quoteCharacter);
        return buffer.toString();
    }
}

