/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Predicate;
import org.basex.query.CompileContext;
import org.basex.query.InlineContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Single;
import org.basex.query.expr.TypeCheck;
import org.basex.query.expr.gflwor.GFLWOR;
import org.basex.query.expr.gflwor.Let;
import org.basex.query.func.fn.FnError;
import org.basex.query.iter.Iter;
import org.basex.query.util.ASTVisitor;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.FBuilder;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Types;
import org.basex.query.var.Var;
import org.basex.query.var.VarUsage;
import org.basex.util.Array;
import org.basex.util.Checks;
import org.basex.util.InputInfo;
import org.basex.util.TokenBuilder;
import org.basex.util.hash.IntObjectMap;

public final class TypeswitchGroup
extends Single {
    SeqType[] seqTypes;
    private Var var;

    public TypeswitchGroup(InputInfo info, Var var, SeqType[] seqTypes, Expr rtrn) {
        super(info, rtrn, Types.ITEM_ZM);
        this.var = var;
        this.seqTypes = seqTypes;
    }

    @Override
    public Expr compile(CompileContext cc) throws QueryException {
        this.expr = cc.compileOrError(this.expr, false);
        return this.optimize(cc);
    }

    @Override
    public Expr optimize(CompileContext cc) throws QueryException {
        if (this.var != null) {
            if (this.expr.count(this.var) == VarUsage.NEVER) {
                cc.info("remove unused variable: %", this.var);
                this.var = null;
            } else {
                this.refineType(cc);
            }
        }
        return this.adoptType(this.expr);
    }

    void inline(Value value, CompileContext cc) throws QueryException {
        if (this.var != null) {
            this.expr = new InlineContext(this.var, this.var.checkType(value, cc.qc, cc), cc).inline(this.expr);
        }
    }

    Expr rewrite(Expr cond, CompileContext cc) throws QueryException {
        if (this.var == null) {
            return cc.voidAndReturn(cond, this.expr, this.info);
        }
        IntObjectMap<Var> vm = new IntObjectMap<Var>();
        Let let = new Let(cc.copy(this.var, vm), cond).optimize(cc);
        Expr rtrn = this.expr.copy(cc, vm).optimize(cc);
        return new GFLWOR(this.info, let, rtrn).optimize(cc);
    }

    boolean removeTypes(SeqType ct, ArrayList<SeqType> cache, CompileContext cc) throws QueryException {
        int sl = this.seqTypes.length;
        if (sl == 0) {
            return true;
        }
        Predicate<SeqType> remove = seqType -> {
            for (SeqType st : cache) {
                if (!seqType.instanceOf(st)) continue;
                return true;
            }
            return seqType.intersect(ct) == null;
        };
        ArrayList<SeqType> tmp = new ArrayList<SeqType>(sl);
        for (SeqType st : this.seqTypes) {
            if (remove.test(st)) {
                cc.info("remove % from %", st, this::description);
                continue;
            }
            tmp.add(st);
            cache.add(st);
        }
        if (sl != tmp.size()) {
            if (tmp.isEmpty()) {
                return false;
            }
            this.seqTypes = (SeqType[])tmp.toArray(SeqType[]::new);
            this.refineType(cc);
        }
        return true;
    }

    @Override
    public Expr inline(InlineContext ic) {
        try {
            return super.inline(ic);
        }
        catch (QueryException ex) {
            this.expr = FnError.get(ex, this);
            return this;
        }
    }

    @Override
    public Expr typeCheck(TypeCheck tc, CompileContext cc) throws QueryException {
        Expr rtrn;
        try {
            rtrn = tc.check(this.expr, cc);
        }
        catch (QueryException ex) {
            rtrn = FnError.get(ex, this.expr);
        }
        if (rtrn == null) {
            return null;
        }
        this.expr = rtrn;
        return this.optimize(cc);
    }

    @Override
    public TypeswitchGroup copy(CompileContext cc, IntObjectMap<Var> vm) {
        return this.copyType(new TypeswitchGroup(this.info, cc.copy(this.var, vm), (SeqType[])this.seqTypes.clone(), this.expr.copy(cc, vm)));
    }

    ArrayList<SeqType> matchingTypes(SeqType ... types) {
        ArrayList<SeqType> tmp = new ArrayList<SeqType>(this.seqTypes.length);
        for (SeqType st : this.seqTypes) {
            if (!((Checks<SeqType>)type -> type.instanceOf(st)).any((SeqType[])types)) continue;
            tmp.add(st);
        }
        return tmp;
    }

    boolean noMatches(SeqType seqType) {
        for (SeqType st : this.seqTypes) {
            if (st.intersect(seqType) == null) continue;
            return false;
        }
        return true;
    }

    boolean match(Value value, QueryContext qc) throws QueryException {
        int sl = this.seqTypes.length;
        boolean found = sl == 0;
        for (int s = 0; !found && s < sl; ++s) {
            found = this.seqTypes[s].instance(value);
        }
        if (found && this.var != null && qc != null) {
            qc.set(this.var, value);
        }
        return found;
    }

    @Override
    public Iter iter(QueryContext qc) throws QueryException {
        return (this.var != null ? this.expr.value(qc) : this.expr).iter(qc);
    }

    @Override
    public Value value(QueryContext qc) throws QueryException {
        return this.expr.value(qc);
    }

    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        return this.expr.item(qc, this.info);
    }

    private void refineType(CompileContext cc) throws QueryException {
        int sl = this.seqTypes.length;
        if (this.var == null || sl == 0) {
            return;
        }
        SeqType st = this.seqTypes[0];
        for (int s = 1; s < sl; ++s) {
            st = st.union(this.seqTypes[s]);
        }
        this.var.refineType(st, cc);
    }

    @Override
    public void markTailCalls(CompileContext cc) {
        this.expr.markTailCalls(cc);
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        return super.accept(visitor) && (this.var == null || visitor.declared(this.var));
    }

    @Override
    public int exprSize() {
        return this.expr.exprSize();
    }

    @Override
    public Expr simplifyFor(CompileContext.Simplify mode, CompileContext cc) throws QueryException {
        Expr rtrn = this.expr;
        this.expr = rtrn.simplifyFor(mode, cc);
        return rtrn != this.expr ? null : this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof TypeswitchGroup)) return false;
        TypeswitchGroup tg = (TypeswitchGroup)obj;
        if (!Array.equals(this.seqTypes, tg.seqTypes)) return false;
        if (!Objects.equals(this.var, tg.var)) return false;
        if (!super.equals(obj)) return false;
        return true;
    }

    @Override
    public void toXml(QueryPlan plan) {
        FBuilder elem = plan.attachVariable(plan.create(this, new Object[0]), this.var, false);
        if (this.seqTypes.length == 0) {
            plan.addAttribute(elem, "default", true);
        } else {
            TokenBuilder tb = new TokenBuilder();
            for (SeqType st : this.seqTypes) {
                if (!tb.isEmpty()) {
                    tb.add(124);
                }
                tb.add(st);
            }
            plan.addAttribute(elem, "case", tb);
        }
        plan.add(elem, this.expr);
    }

    @Override
    public void toString(QueryString qs) {
        boolean cases = this.seqTypes.length > 0;
        qs.token(cases ? "case" : "default");
        if (this.var != null) {
            qs.token(this.var);
            if (cases) {
                qs.token("as");
            }
        }
        if (cases) {
            qs.tokens(this.seqTypes, "|");
        }
        qs.token("return").token(this.expr);
    }
}

