/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.map;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.BasicIter;
import org.basex.query.iter.Iter;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.map.XQMap;
import org.basex.query.value.type.MapType;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.Type;

public class MapEntries
extends StandardFunc {
    @Override
    public final Iter iter(QueryContext qc) throws QueryException {
        final XQMap map = this.toMap(this.arg(0), qc);
        return new Iter(){
            final BasicIter<Item> keys;
            {
                this.keys = map.keys().iter();
            }

            @Override
            public XQMap next() throws QueryException {
                Item key = this.keys.next();
                return key != null ? MapEntries.this.entry(key, map.get(key)) : null;
            }

            @Override
            public Item get(long i) throws QueryException {
                Item key = this.keys.get(i);
                return MapEntries.this.entry(key, map.get(key));
            }

            @Override
            public long size() {
                return map.structSize();
            }
        };
    }

    @Override
    protected Expr opt(CompileContext cc) {
        Expr map = this.arg(0);
        Type type = map.seqType().type;
        if (type instanceof MapType) {
            this.exprType.assign(type.seqType(Occ.ZERO_OR_MORE), map.structSize());
        }
        return this;
    }

    XQMap entry(Item key, Value value) throws QueryException {
        return XQMap.get(key, value);
    }
}

