/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.db;

import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.db.MultipleEntry;
import com.sleepycat.db.internal.DbUtil;
import java.nio.ByteBuffer;

public class MultipleNIODataEntry
extends MultipleEntry {
    public MultipleNIODataEntry() {
        super((ByteBuffer)null);
    }

    public MultipleNIODataEntry(ByteBuffer byteBuffer) {
        super(byteBuffer);
    }

    @Override
    int getMultiFlag() {
        this.pos = 0;
        return 2048;
    }

    public boolean next(DatabaseEntry databaseEntry) {
        if (this.pos == 0) {
            this.pos = this.ulen - 4;
        }
        if (this.data_nio.capacity() < 8) {
            return false;
        }
        byte[] byArray = new byte[8];
        int n = this.data_nio.position();
        this.data_nio.position(this.pos - 4);
        this.data_nio.get(byArray, 0, 8);
        this.data_nio.position(n);
        int n2 = DbUtil.array2int(byArray, 4);
        if (n2 < 0) {
            return false;
        }
        int n3 = DbUtil.array2int(byArray, 0);
        this.pos -= 8;
        databaseEntry.setDataNIO(this.data_nio);
        databaseEntry.setSize(n3);
        databaseEntry.setOffset(n2);
        return true;
    }
}

