/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.swt.properties.converters;

import org.eclipse.e4.ui.css.core.dom.properties.converters.AbstractCSSValueConverter;
import org.eclipse.e4.ui.css.core.dom.properties.converters.ICSSValueConverter;
import org.eclipse.e4.ui.css.core.dom.properties.converters.ICSSValueConverterConfig;
import org.eclipse.e4.ui.css.core.dom.properties.css2.CSS2FontProperties;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.swt.helpers.CSSSWTFontHelper;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.w3c.dom.css.CSSValue;

public class CSSValueSWTFontDataConverterImpl
extends AbstractCSSValueConverter {
    public static final ICSSValueConverter INSTANCE = new CSSValueSWTFontDataConverterImpl();

    public CSSValueSWTFontDataConverterImpl(Object toType) {
        super(toType);
    }

    public CSSValueSWTFontDataConverterImpl() {
        super(FontData.class);
    }

    public Object convert(CSSValue value, CSSEngine engine, Object context) throws Exception {
        FontData fontData = null;
        if (context != null) {
            Font font;
            if (context instanceof Display) {
                Display display = (Display)context;
                Font font2 = display.getSystemFont();
                fontData = CSSSWTFontHelper.getFirstFontData(font2);
            }
            if (context instanceof Control) {
                Control control = (Control)context;
                Font font3 = control.getFont();
                fontData = CSSSWTFontHelper.getFirstFontData(font3);
            }
            if (context instanceof CTabItem) {
                CTabItem item = (CTabItem)context;
                font = item.getFont();
                fontData = CSSSWTFontHelper.getFirstFontData(font);
            }
            if (context instanceof Font) {
                font = (Font)context;
                fontData = CSSSWTFontHelper.getFirstFontData(font);
            }
        }
        if (fontData != null && value instanceof CSS2FontProperties) {
            return CSSSWTFontHelper.getFontData((CSS2FontProperties)value, fontData);
        }
        return null;
    }

    public String convert(Object value, CSSEngine engine, Object context, ICSSValueConverterConfig config) throws Exception {
        String s;
        String property;
        FontData fontData = (FontData)value;
        switch (property = context instanceof String ? (s = (String)context) : "") {
            case "font-family": {
                return CSSSWTFontHelper.getFontFamily(fontData);
            }
            case "font-size": {
                return CSSSWTFontHelper.getFontSize(fontData);
            }
            case "font-style": {
                return CSSSWTFontHelper.getFontStyle(fontData);
            }
            case "font-weight": {
                return CSSSWTFontHelper.getFontWeight(fontData);
            }
            case "font": {
                return CSSSWTFontHelper.getFontComposite(fontData);
            }
        }
        return null;
    }

    protected Display getDisplay(Object context) {
        if (context instanceof Display) {
            return (Display)context;
        }
        if (context instanceof Control) {
            return ((Control)context).getDisplay();
        }
        return null;
    }
}

