/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.structuremergeviewer;

import java.util.ArrayList;
import org.eclipse.compare.structuremergeviewer.DiffElement;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.compare.structuremergeviewer.IDiffElement;

public abstract class DiffContainer
extends DiffElement
implements IDiffContainer {
    private static IDiffElement[] fgEmptyArray = new IDiffElement[0];
    private ArrayList<IDiffElement> fChildren;

    public DiffContainer(IDiffContainer parent, int kind) {
        super(parent, kind);
    }

    public IDiffElement findChild(String name) {
        IDiffElement[] children;
        IDiffElement[] iDiffElementArray = children = this.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IDiffElement c = iDiffElementArray[n2];
            IDiffElement child = c;
            if (name.equals(child.getName())) {
                return child;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public void add(IDiffElement diff) {
        if (this.fChildren == null) {
            this.fChildren = new ArrayList();
        }
        this.fChildren.add(diff);
        diff.setParent(this);
    }

    @Override
    public void removeToRoot(IDiffElement child) {
        if (this.fChildren != null) {
            IDiffContainer p;
            this.fChildren.remove(child);
            child.setParent(null);
            if (this.fChildren.isEmpty() && (p = this.getParent()) != null) {
                p.removeToRoot(this);
            }
        }
    }

    public void remove(IDiffElement child) {
        if (this.fChildren != null) {
            this.fChildren.remove(child);
            child.setParent(null);
        }
    }

    @Override
    public boolean hasChildren() {
        return this.fChildren != null && this.fChildren.size() > 0;
    }

    @Override
    public IDiffElement[] getChildren() {
        if (this.fChildren != null) {
            return this.fChildren.toArray(fgEmptyArray);
        }
        return fgEmptyArray;
    }
}

