/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.clickhouse.model;

import java.sql.SQLException;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.clickhouse.model.ClickhouseTable;
import org.jkiss.dbeaver.ext.generic.model.GenericCatalog;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericSchema;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.ext.generic.model.GenericTableColumn;
import org.jkiss.dbeaver.ext.generic.model.TableCache;
import org.jkiss.dbeaver.model.DBPObjectStatisticsCollector;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.SimpleObjectCache;

public class ClickhouseSchema
extends GenericSchema
implements DBPObjectStatisticsCollector {
    private boolean hasStatistics = true;

    public ClickhouseSchema(@NotNull GenericDataSource dataSource, @Nullable GenericCatalog catalog, @NotNull String schemaName) {
        super(dataSource, catalog, schemaName);
    }

    public TableCache createTableCache(GenericDataSource datasource) {
        return new TableCache(datasource){

            protected void detectCaseSensitivity(DBSObject object) {
                this.setCaseSensitive(true);
            }

            @NotNull
            protected SimpleObjectCache<GenericTableBase, GenericTableColumn> createNestedCache() {
                return new SimpleObjectCache<GenericTableBase, GenericTableColumn>(){

                    protected void detectCaseSensitivity(DBSObject object) {
                        this.setCaseSensitive(true);
                    }
                };
            }
        };
    }

    public List<ClickhouseTable> getPhysicalTables(@NotNull DBRProgressMonitor monitor) throws DBException {
        return super.getPhysicalTables(monitor);
    }

    public List<ClickhouseTable> getTables(@NotNull DBRProgressMonitor monitor) throws DBException {
        return super.getTables(monitor);
    }

    public boolean isStatisticsCollected() {
        return this.hasStatistics;
    }

    public synchronized DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.resetStatistics();
        return super.refreshObject(monitor);
    }

    void resetStatistics() {
        this.hasStatistics = false;
    }

    public void collectObjectStatistics(@NotNull DBRProgressMonitor monitor, boolean totalSizeOnly, boolean forceRefresh) throws DBException {
        if (this.hasStatistics && !forceRefresh) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var5_6 = null;
            try (DBCSession session = DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Read relation statistics");){
                try {
                    Throwable throwable2 = null;
                    Object var8_12 = null;
                    try (JDBCPreparedStatement dbStat = ((JDBCSession)session).prepareStatement("select table,sum(bytes) as table_size, sum(rows) as table_rows, max(modification_time) as latest_modification,min(min_date) AS min_date,max(max_date) AS max_date FROM system.parts\nWHERE database=? AND active\nGROUP BY table");){
                        dbStat.setString(1, this.getName());
                        Throwable throwable3 = null;
                        Object var11_17 = null;
                        try (JDBCResultSet dbResult = dbStat.executeQuery();){
                            while (dbResult.next()) {
                                String tableName = dbResult.getString(1);
                                GenericTableBase table = this.getTable(monitor, tableName);
                                if (!(table instanceof ClickhouseTable)) continue;
                                ((ClickhouseTable)table).fetchStatistics(dbResult);
                            }
                        }
                        catch (Throwable throwable4) {
                            if (throwable3 == null) {
                                throwable3 = throwable4;
                            } else if (throwable3 != throwable4) {
                                throwable3.addSuppressed(throwable4);
                            }
                            throw throwable3;
                        }
                    }
                    catch (Throwable throwable5) {
                        if (throwable2 == null) {
                            throwable2 = throwable5;
                        } else if (throwable2 != throwable5) {
                            throwable2.addSuppressed(throwable5);
                        }
                        throw throwable2;
                    }
                }
                catch (SQLException e) {
                    throw new DBCException("Error reading schema statistics", (Throwable)e);
                }
            }
            catch (Throwable throwable6) {
                if (throwable == null) {
                    throwable = throwable6;
                } else if (throwable != throwable6) {
                    throwable.addSuppressed(throwable6);
                }
                throw throwable;
            }
        }
        finally {
            this.hasStatistics = true;
        }
    }

    @NotNull
    public Class<? extends DBSEntity> getPrimaryChildType(@Nullable DBRProgressMonitor monitor) throws DBException {
        return ClickhouseTable.class;
    }
}

