/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.ui.refactoring;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringUIPlugin;
import org.eclipse.swt.graphics.Image;
import org.osgi.framework.Bundle;

public class RefactoringPluginImages {
    private static final String NAME_PREFIX = "org.eclipse.ltk.ui.refactoring";
    private static final int NAME_PREFIX_LENGTH = "org.eclipse.ltk.ui.refactoring".length();
    private static final IPath ICONS_PATH = new Path("$nl$/icons/full");
    private static ImageRegistry fgImageRegistry = null;
    private static HashMap<String, ImageDescriptor> fgAvoidSWTErrorMap = null;
    private static final String T_WIZBAN = "wizban";
    private static final String T_OBJ = "obj16";
    private static final String T_OVR = "ovr16";
    private static final String T_ELCL = "elcl16";
    public static final ImageDescriptor DESC_WIZBAN_REFACTOR = RefactoringPluginImages.createUnManaged("wizban", "refactor_wiz.svg");
    public static final ImageDescriptor DESC_WIZBAN_SHOW_HISTORY = RefactoringPluginImages.createUnManaged("wizban", "show_history_wiz.svg");
    public static final ImageDescriptor DESC_WIZBAN_APPLY_SCRIPT = RefactoringPluginImages.createUnManaged("wizban", "apply_rescript_wiz.svg");
    public static final ImageDescriptor DESC_WIZBAN_CREATE_SCRIPT = RefactoringPluginImages.createUnManaged("wizban", "create_rescript_wiz.svg");
    public static final String IMG_OBJS_REFACTORING_FATAL = "org.eclipse.ltk.ui.refactoringfatalerror_obj.svg";
    public static final String IMG_OBJS_REFACTORING_ERROR = "org.eclipse.ltk.ui.refactoringerror_obj.svg";
    public static final String IMG_OBJS_REFACTORING_WARNING = "org.eclipse.ltk.ui.refactoringwarning_obj.svg";
    public static final String IMG_OBJS_REFACTORING_INFO = "org.eclipse.ltk.ui.refactoringinfo_obj.svg";
    public static final String IMG_OBJS_REFACTORING_DATE = "org.eclipse.ltk.ui.refactoringdate_obj.svg";
    public static final String IMG_OBJS_REFACTORING_TIME = "org.eclipse.ltk.ui.refactoringtime_obj.svg";
    public static final ImageDescriptor DESC_ELCL_FILTER = RefactoringPluginImages.createUnManaged("elcl16", "filter_ps.svg");
    public static final ImageDescriptor DESC_ELCL_SORT_PROJECT = RefactoringPluginImages.createUnManaged("elcl16", "prj_mode.svg");
    public static final ImageDescriptor DESC_ELCL_SORT_DATE = RefactoringPluginImages.createUnManaged("elcl16", "date_mode.svg");
    public static final ImageDescriptor DESC_OBJS_REFACTORING_FATAL = RefactoringPluginImages.createManaged("obj16", "org.eclipse.ltk.ui.refactoringfatalerror_obj.svg");
    public static final ImageDescriptor DESC_OBJS_REFACTORING_ERROR = RefactoringPluginImages.createManaged("obj16", "org.eclipse.ltk.ui.refactoringerror_obj.svg");
    public static final ImageDescriptor DESC_OBJS_REFACTORING_WARNING = RefactoringPluginImages.createManaged("obj16", "org.eclipse.ltk.ui.refactoringwarning_obj.svg");
    public static final ImageDescriptor DESC_OBJS_REFACTORING_INFO = RefactoringPluginImages.createManaged("obj16", "org.eclipse.ltk.ui.refactoringinfo_obj.svg");
    public static final ImageDescriptor DESC_OBJS_REFACTORING_DATE = RefactoringPluginImages.createUnManaged("obj16", "date_obj.svg");
    public static final ImageDescriptor DESC_OBJS_REFACTORING_TIME = RefactoringPluginImages.createUnManaged("obj16", "time_obj.svg");
    public static final ImageDescriptor DESC_OBJS_REFACTORING = RefactoringPluginImages.createUnManaged("obj16", "refactoring_obj.svg");
    public static final ImageDescriptor DESC_OBJS_REFACTORING_COLL = RefactoringPluginImages.createUnManaged("obj16", "refactorings_obj.svg");
    public static final ImageDescriptor DESC_OVR_WORKSPACE = RefactoringPluginImages.createUnManaged("ovr16", "workspace_ovr.svg");
    public static final ImageDescriptor DESC_OBJS_DEFAULT_CHANGE = RefactoringPluginImages.createUnManaged("obj16", "change.svg");
    public static final ImageDescriptor DESC_OBJS_COMPOSITE_CHANGE = RefactoringPluginImages.createUnManaged("obj16", "composite_change.svg");
    public static final ImageDescriptor DESC_OBJS_FILE_CHANGE = RefactoringPluginImages.createUnManaged("obj16", "file_change.svg");
    public static final ImageDescriptor DESC_OBJS_TEXT_EDIT = RefactoringPluginImages.createUnManaged("obj16", "text_edit.svg");

    public static Image get(String key) {
        return RefactoringPluginImages.getImageRegistry().get(key);
    }

    public static void setToolImageDescriptors(IAction action, String iconName) {
        RefactoringPluginImages.setImageDescriptors(action, "tool16", iconName);
    }

    public static void setLocalImageDescriptors(IAction action, String iconName) {
        RefactoringPluginImages.setImageDescriptors(action, "lcl16", iconName);
    }

    static ImageRegistry getImageRegistry() {
        if (fgImageRegistry == null) {
            fgImageRegistry = new ImageRegistry();
            for (Map.Entry<String, ImageDescriptor> entry : fgAvoidSWTErrorMap.entrySet()) {
                String key = entry.getKey();
                fgImageRegistry.put(key, entry.getValue());
            }
            fgAvoidSWTErrorMap = null;
        }
        return fgImageRegistry;
    }

    private static void setImageDescriptors(IAction action, String type, String relPath) {
        ImageDescriptor descriptor = RefactoringPluginImages.create("e" + type, relPath, true);
        action.setImageDescriptor(descriptor);
    }

    private static ImageDescriptor createManaged(String prefix, String name) {
        ImageDescriptor result = RefactoringPluginImages.create(prefix, name.substring(NAME_PREFIX_LENGTH), true);
        if (fgAvoidSWTErrorMap == null) {
            fgAvoidSWTErrorMap = new HashMap();
        }
        fgAvoidSWTErrorMap.put(name, result);
        if (fgImageRegistry != null) {
            RefactoringUIPlugin.logErrorMessage("Image registry already defined");
        }
        return result;
    }

    private static ImageDescriptor createUnManaged(String prefix, String name) {
        return RefactoringPluginImages.create(prefix, name, true);
    }

    private static ImageDescriptor create(String prefix, String name, boolean useMissingImageDescriptor) {
        IPath path = ICONS_PATH.append(prefix).append(name);
        return RefactoringPluginImages.createImageDescriptor(RefactoringUIPlugin.getDefault().getBundle(), path, useMissingImageDescriptor);
    }

    private static ImageDescriptor createImageDescriptor(Bundle bundle, IPath path, boolean useMissingImageDescriptor) {
        URL url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        if (url != null) {
            return ImageDescriptor.createFromURL((URL)url);
        }
        if (useMissingImageDescriptor) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
        return null;
    }

    private RefactoringPluginImages() {
    }
}

