/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dashboard.control;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.dashboard.DBDashboardCalcType;
import org.jkiss.dbeaver.model.dashboard.DBDashboardDataType;
import org.jkiss.dbeaver.model.dashboard.DBDashboardFetchType;
import org.jkiss.dbeaver.model.dashboard.DBDashboardInterval;
import org.jkiss.dbeaver.model.dashboard.DBDashboardValueType;
import org.jkiss.dbeaver.model.dashboard.registry.DashboardItemConfiguration;
import org.jkiss.dbeaver.ui.IObjectPropertyConfigurator;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dashboard.internal.UIDashboardMessages;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardRendererType;
import org.jkiss.dbeaver.ui.dashboard.registry.DashboardRendererDescriptor;
import org.jkiss.dbeaver.ui.dashboard.registry.DashboardUIRegistry;
import org.jkiss.dbeaver.ui.dashboard.view.DashboardDatabaseSelectDialog;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class DatabaseChartConfigurationEditor
implements IObjectPropertyConfigurator<DashboardItemConfiguration, DashboardItemConfiguration> {
    private Text queryText;
    private Combo viewTypeCombo;
    private Text updatePeriodText;
    private Text maxItemsText;
    private List<DashboardRendererType> viewTypes;
    private Combo dataTypeCombo;
    private Combo calcTypeCombo;
    private Combo valueTypeCombo;
    private Combo intervalCombo;
    private Combo fetchTypeCombo;
    private DBPNamedObject targetDatabase;

    public void createControl(final @NotNull Composite composite, DashboardItemConfiguration itemDescriptor, final @NotNull Runnable propertyChangeListener) {
        DashboardRendererType viewType2;
        DBDashboardDataType dvt;
        List dataSourceMappings = itemDescriptor.getDataSourceMappings();
        if (!dataSourceMappings.isEmpty()) {
            this.targetDatabase = (DBPNamedObject)dataSourceMappings.get(0);
        }
        boolean readOnly = !itemDescriptor.isCustom();
        int baseStyle = !readOnly ? 0 : 8;
        Composite mainGroup = UIUtils.createComposite((Composite)composite, (int)2);
        mainGroup.setLayoutData((Object)new GridData(768));
        UIUtils.createControlLabel((Composite)mainGroup, (String)UIDashboardMessages.dialog_edit_dashboard_maininfo_labels_db);
        Composite dbSelectorPanel = UIUtils.createComposite((Composite)mainGroup, (int)2);
        GridData gd = new GridData(768);
        dbSelectorPanel.setLayoutData((Object)gd);
        final Text dbSelectorText = new Text(dbSelectorPanel, 2056);
        dbSelectorText.setLayoutData((Object)new GridData(768));
        if (this.targetDatabase != null) {
            dbSelectorText.setText(this.targetDatabase.getName());
        }
        UIUtils.createPushButton((Composite)dbSelectorPanel, (String)UIDashboardMessages.dialog_edit_dashboard_maininfo_buttons_select, null, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DashboardDatabaseSelectDialog selectDialog = new DashboardDatabaseSelectDialog(composite.getShell());
                if (selectDialog.open() == 0) {
                    DatabaseChartConfigurationEditor.this.targetDatabase = selectDialog.getTarget();
                    dbSelectorText.setText(DatabaseChartConfigurationEditor.this.targetDatabase.getName());
                }
                propertyChangeListener.run();
            }
        });
        this.dataTypeCombo = UIUtils.createLabelCombo((Composite)mainGroup, (String)UIDashboardMessages.dialog_edit_dashboard_maininfo_combos_datatype, (String)UIDashboardMessages.dialog_edit_dashboard_maininfo_combos_datatype_tooltip, (int)2060);
        DBDashboardDataType[] dBDashboardDataTypeArray = DBDashboardDataType.values();
        int n = dBDashboardDataTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            DBDashboardDataType ddt = dBDashboardDataTypeArray[n2];
            this.dataTypeCombo.add(ddt.name());
            ++n2;
        }
        this.dataTypeCombo.setText(itemDescriptor.getDataType().name());
        this.dataTypeCombo.setEnabled(!readOnly);
        this.calcTypeCombo = UIUtils.createLabelCombo((Composite)mainGroup, (String)UIDashboardMessages.dialog_edit_dashboard_maininfo_combos_calctype, (String)UIDashboardMessages.dialog_edit_dashboard_maininfo_combos_calctype_tooltip, (int)2060);
        dBDashboardDataTypeArray = DBDashboardCalcType.values();
        n = dBDashboardDataTypeArray.length;
        n2 = 0;
        while (n2 < n) {
            DBDashboardDataType dct = dBDashboardDataTypeArray[n2];
            this.calcTypeCombo.add(dct.name());
            ++n2;
        }
        this.calcTypeCombo.setText(itemDescriptor.getCalcType().name());
        this.calcTypeCombo.setEnabled(!readOnly);
        this.valueTypeCombo = UIUtils.createLabelCombo((Composite)mainGroup, (String)UIDashboardMessages.dialog_edit_dashboard_maininfo_combos_valuetype, (String)UIDashboardMessages.dialog_edit_dashboard_maininfo_combos_valuetype_tooltip, (int)2060);
        dBDashboardDataTypeArray = DBDashboardValueType.values();
        n = dBDashboardDataTypeArray.length;
        n2 = 0;
        while (n2 < n) {
            dvt = dBDashboardDataTypeArray[n2];
            this.valueTypeCombo.add(dvt.name());
            ++n2;
        }
        this.valueTypeCombo.setText(itemDescriptor.getValueType().name());
        this.valueTypeCombo.setEnabled(!readOnly);
        this.intervalCombo = UIUtils.createLabelCombo((Composite)mainGroup, (String)UIDashboardMessages.dialog_edit_dashboard_maininfo_combos_interval, (String)UIDashboardMessages.dialog_edit_dashboard_maininfo_combos_interval_tooltip, (int)2060);
        dBDashboardDataTypeArray = DBDashboardInterval.values();
        n = dBDashboardDataTypeArray.length;
        n2 = 0;
        while (n2 < n) {
            dvt = dBDashboardDataTypeArray[n2];
            this.intervalCombo.add(dvt.name());
            ++n2;
        }
        this.intervalCombo.setText(itemDescriptor.getInterval().name());
        this.intervalCombo.setEnabled(!readOnly);
        this.fetchTypeCombo = UIUtils.createLabelCombo((Composite)mainGroup, (String)UIDashboardMessages.dialog_edit_dashboard_maininfo_combos_fetchtype, (String)UIDashboardMessages.dialog_edit_dashboard_maininfo_combos_fetchtype_tooltip, (int)2060);
        dBDashboardDataTypeArray = DBDashboardFetchType.values();
        n = dBDashboardDataTypeArray.length;
        n2 = 0;
        while (n2 < n) {
            DBDashboardDataType dft = dBDashboardDataTypeArray[n2];
            this.fetchTypeCombo.add(dft.name());
            ++n2;
        }
        this.fetchTypeCombo.setText(itemDescriptor.getFetchType().name());
        this.fetchTypeCombo.setEnabled(!readOnly);
        UIUtils.createControlLabel((Composite)composite, (String)UIDashboardMessages.dialog_edit_dashboard_queries, (int)2);
        Composite sqlGroup = UIUtils.createComposite((Composite)composite, (int)1);
        sqlGroup.setLayoutData((Object)new GridData(768));
        this.queryText = new Text(sqlGroup, 0xA42 | baseStyle);
        GridData gd2 = new GridData(1808);
        gd2.heightHint = 100;
        gd2.widthHint = 400;
        this.queryText.setLayoutData((Object)gd2);
        UIUtils.createInfoLabel((Composite)sqlGroup, (String)UIDashboardMessages.dialog_edit_dashboard_queries_infolabels_separator);
        String lineSeparator = GeneralUtils.getDefaultLineSeparator();
        StringBuilder sql = new StringBuilder();
        for (DashboardItemConfiguration.QueryMapping query : itemDescriptor.getQueries()) {
            sql.append(query.getQueryText().trim()).append(lineSeparator).append(lineSeparator);
        }
        if (itemDescriptor.getMapQuery() != null) {
            sql.append(itemDescriptor.getMapQuery().getQueryText()).append(lineSeparator).append(lineSeparator);
            if (!ArrayUtils.isEmpty((Object[])itemDescriptor.getMapKeys())) {
                sql.append(UIDashboardMessages.dialog_edit_dashboard_queries_keys).append(" ").append(Arrays.toString(itemDescriptor.getMapKeys())).append(lineSeparator);
            }
            if (!ArrayUtils.isEmpty((Object[])itemDescriptor.getMapLabels())) {
                sql.append(UIDashboardMessages.dialog_edit_dashboard_queries_labels).append(" ").append(Arrays.toString(itemDescriptor.getMapLabels())).append(lineSeparator);
            }
        }
        this.queryText.setText(sql.toString().trim());
        this.queryText.addModifyListener(e -> propertyChangeListener.run());
        UIUtils.createControlLabel((Composite)composite, (String)UIDashboardMessages.dialog_edit_dashboard_rendering, (int)2);
        Composite updateGroup = UIUtils.createComposite((Composite)composite, (int)2);
        updateGroup.setLayoutData((Object)new GridData(768));
        this.viewTypeCombo = UIUtils.createLabelCombo((Composite)updateGroup, (String)UIDashboardMessages.dialog_edit_dashboard_rendering_combos_defaultview, (String)UIDashboardMessages.dialog_edit_dashboard_rendering_combos_defaultview_tooltip, (int)2056);
        this.viewTypeCombo.setLayoutData((Object)new GridData(768));
        this.viewTypes = DashboardUIRegistry.getInstance().getAllViewTypes();
        for (DashboardRendererType viewType2 : this.viewTypes) {
            this.viewTypeCombo.add(viewType2.getTitle());
        }
        viewType2 = DashboardUIRegistry.getInstance().getViewType(itemDescriptor.getDashboardRenderer());
        this.viewTypeCombo.setText(((DashboardRendererDescriptor)viewType2).getTitle());
        if (this.viewTypeCombo.getSelectionIndex() < 0) {
            this.viewTypeCombo.select(0);
        }
        this.viewTypeCombo.setEnabled(!readOnly);
        this.updatePeriodText = UIUtils.createLabelText((Composite)updateGroup, (String)UIDashboardMessages.dialog_edit_dashboard_rendering_labels_updateperiod, (String)String.valueOf(itemDescriptor.getUpdatePeriod()), (int)(0x800 | baseStyle), (Object)new GridData(768));
        this.maxItemsText = UIUtils.createLabelText((Composite)updateGroup, (String)UIDashboardMessages.dialog_edit_dashboard_rendering_labels_maxitems, (String)String.valueOf(itemDescriptor.getMaxItems()), (int)(0x800 | baseStyle), (Object)new GridData(768));
    }

    public void loadSettings(@NotNull DashboardItemConfiguration itemConfiguration) {
    }

    public void saveSettings(@NotNull DashboardItemConfiguration itemDescriptor) {
        itemDescriptor.setDataSourceMappings(Collections.singletonList(this.targetDatabase));
        itemDescriptor.setDataType(DBDashboardDataType.values()[this.dataTypeCombo.getSelectionIndex()]);
        itemDescriptor.setCalcType(DBDashboardCalcType.values()[this.calcTypeCombo.getSelectionIndex()]);
        itemDescriptor.setValueType(DBDashboardValueType.values()[this.valueTypeCombo.getSelectionIndex()]);
        itemDescriptor.setInterval(DBDashboardInterval.values()[this.intervalCombo.getSelectionIndex()]);
        itemDescriptor.setFetchType(DBDashboardFetchType.values()[this.fetchTypeCombo.getSelectionIndex()]);
        itemDescriptor.setQueries(this.queryText.getText().split("\\n\\s*\\n"));
        itemDescriptor.setRenderer(this.viewTypes.get(this.viewTypeCombo.getSelectionIndex()).getId());
        itemDescriptor.setUpdatePeriod(CommonUtils.toLong((Object)this.updatePeriodText.getText(), (long)itemDescriptor.getUpdatePeriod()));
        itemDescriptor.setMaxItems(CommonUtils.toInt((Object)this.maxItemsText.getText(), (int)itemDescriptor.getMaxItems()));
    }

    public void resetSettings(@NotNull DashboardItemConfiguration itemConfiguration) {
    }

    public boolean isComplete() {
        return !(this.queryText != null && this.queryText.getText().isEmpty() || this.viewTypeCombo != null && this.viewTypeCombo.getSelectionIndex() < 0 || this.targetDatabase == null);
    }
}

