/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.ai.engine.openai;

import com.google.gson.annotations.SerializedName;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.ai.engine.AIModel;
import org.jkiss.dbeaver.model.ai.engine.AIModelFeature;
import org.jkiss.dbeaver.model.ai.engine.openai.OpenAIBaseProperties;
import org.jkiss.dbeaver.model.ai.engine.openai.OpenAIModels;
import org.jkiss.dbeaver.model.ai.utils.AIUtils;
import org.jkiss.dbeaver.model.meta.IPropertyValueListProvider;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.SecureProperty;
import org.jkiss.dbeaver.model.secret.DBSSecretController;
import org.jkiss.dbeaver.runtime.DBWorkbench;

public class OpenAIProperties
implements OpenAIBaseProperties {
    private static final String GPT_BASE_URL = "gpt.base_url";
    private static final String GPT_TOKEN = "gpt.token";
    private static final String GPT_MODEL = "gpt.model";
    private static final String GPT_CONTEXT_WINDOW_SIZE = "gpt.contextWindowSize";
    private static final String GPT_MODEL_TEMPERATURE = "gpt.model.temperature";
    private static final String GPT_LOG_QUERY = "gpt.log.query";
    private static final String GPT_LEGACY_API = "gpt.api.legacy";
    @SerializedName(value="gpt.base_url")
    @Nullable
    private String baseUrl;
    @SecureProperty
    @SerializedName(value="gpt.token")
    @Nullable
    private String token;
    @SerializedName(value="gpt.model")
    @Nullable
    private String model;
    @SerializedName(value="gpt.contextWindowSize")
    @Nullable
    private Integer contextWindowSize;
    @SerializedName(value="gpt.model.temperature")
    private Double temperature;
    @SerializedName(value="gpt.log.query")
    private Boolean loggingEnabled;
    @SerializedName(value="gpt.api.legacy")
    private boolean useLegacyApi;

    @Override
    @Property(order=2, required=true)
    @NotNull
    public String getBaseUrl() {
        if (this.baseUrl == null || this.baseUrl.isEmpty()) {
            return "https://api.openai.com/v1/";
        }
        return this.baseUrl;
    }

    public void setBaseUrl(@Nullable String baseUrl) {
        this.baseUrl = baseUrl;
    }

    @Override
    @Property(order=1, password=true, required=true)
    @Nullable
    public String getToken() {
        return this.token;
    }

    @Override
    @Property(order=7)
    public boolean isLegacyApi() {
        return this.useLegacyApi;
    }

    public void setLegacyApi(boolean useLegacyApi) {
        this.useLegacyApi = useLegacyApi;
    }

    public void setToken(@Nullable String token) {
        this.token = token;
    }

    @Override
    @Property(order=3, listProvider=OpenAIModelListProvider.class)
    @Nullable
    public String getModel() {
        if (this.model != null) {
            return OpenAIModels.getEffectiveModelName(this.model);
        }
        String modelName = DBWorkbench.getPlatform().getPreferenceStore().getString(GPT_MODEL);
        return OpenAIModels.getEffectiveModelName(modelName);
    }

    public void setModel(@Nullable String model) {
        this.model = model;
    }

    @Override
    @Property(order=4)
    public double getTemperature() {
        if (this.temperature != null) {
            return this.temperature;
        }
        return DBWorkbench.getPlatform().getPreferenceStore().getDouble(GPT_MODEL_TEMPERATURE);
    }

    public void setTemperature(double temperature) {
        this.temperature = temperature;
    }

    @Override
    @Property(order=5)
    public boolean isLoggingEnabled() {
        if (this.loggingEnabled != null) {
            return this.loggingEnabled;
        }
        return DBWorkbench.getPlatform().getPreferenceStore().getBoolean(GPT_LOG_QUERY);
    }

    public void setLoggingEnabled(boolean loggingEnabled) {
        this.loggingEnabled = loggingEnabled;
    }

    @Override
    @Property(order=6)
    @Nullable
    public Integer getContextWindowSize() {
        if (this.contextWindowSize != null) {
            return this.contextWindowSize;
        }
        return OpenAIModels.getModelByName(this.getModel()).map(AIModel::contextWindowSize).orElse(null);
    }

    public void setContextWindowSize(@Nullable Integer contextWindowSize) {
        this.contextWindowSize = contextWindowSize;
    }

    @Override
    public void resolveSecrets() throws DBException {
        this.token = AIUtils.getSecretValueOrDefault(GPT_TOKEN, this.token);
    }

    @Override
    public void saveSecrets() throws DBException {
        if (this.token != null) {
            DBSSecretController.getGlobalSecretController().setPrivateSecretValue(GPT_TOKEN, this.token);
        }
    }

    public static class OpenAIModelListProvider
    implements IPropertyValueListProvider<OpenAIProperties> {
        public boolean allowCustomValue() {
            return false;
        }

        @Nullable
        public Object[] getPossibleValues(OpenAIProperties object) {
            return OpenAIModels.KNOWN_MODELS.entrySet().stream().filter(entry -> !((AIModel)entry.getValue()).features().contains((Object)AIModelFeature.SPEECH_TO_TEXT)).map(Map.Entry::getKey).toArray();
        }
    }
}

