/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.model;

import java.sql.ResultSet;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.mysql.model.MySQLDataSource;
import org.jkiss.dbeaver.ext.mysql.model.MySQLInformation;
import org.jkiss.dbeaver.model.DBPStatefulObject;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObjectState;
import org.jkiss.utils.CommonUtils;

public class MySQLPlugin
extends MySQLInformation
implements DBPStatefulObject {
    private final String name;
    private final Status status;
    private final String type;
    private final String library;
    private final String license;

    public MySQLPlugin(@NotNull MySQLDataSource dataSource, @NotNull ResultSet dbResult) {
        super(dataSource);
        this.name = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"NAME");
        this.status = (Status)CommonUtils.valueOf(Status.class, (String)JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"STATUS"), (Enum)Status.UNKNOWN);
        this.type = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TYPE");
        this.library = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"LIBRARY");
        this.license = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"LICENSE");
    }

    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    @Property(viewable=true, order=2)
    @NotNull
    public Status getStatus() {
        return this.status;
    }

    @Property(viewable=true, order=3)
    @NotNull
    public String getType() {
        return this.type;
    }

    @Property(viewable=true, order=4)
    @Nullable
    public String getLibrary() {
        return this.library;
    }

    @Property(viewable=true, order=4)
    @NotNull
    public String getLicense() {
        return this.license;
    }

    @Nullable
    public String getDescription() {
        return null;
    }

    @NotNull
    public DBSObjectState getObjectState() {
        if (this.status == Status.ACTIVE) {
            return DBSObjectState.ACTIVE;
        }
        if (this.status == Status.UNKNOWN) {
            return DBSObjectState.UNKNOWN;
        }
        return DBSObjectState.NORMAL;
    }

    public void refreshObjectState(@NotNull DBRProgressMonitor monitor) {
    }

    public static enum Status {
        ACTIVE,
        INACTIVE,
        DISABLED,
        DELETING,
        DELETED,
        UNKNOWN,
        INSTALLED;

    }
}

