/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry.task;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.Strictness;
import com.google.gson.stream.JsonWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.dbeaver.model.impl.app.BaseProjectImpl;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.task.DBTScheduler;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.model.task.DBTTaskEvent;
import org.jkiss.dbeaver.model.task.DBTTaskExecutionListener;
import org.jkiss.dbeaver.model.task.DBTTaskFolder;
import org.jkiss.dbeaver.model.task.DBTTaskFolderEvent;
import org.jkiss.dbeaver.model.task.DBTTaskManager;
import org.jkiss.dbeaver.model.task.DBTTaskRegistry;
import org.jkiss.dbeaver.model.task.DBTTaskRunStatus;
import org.jkiss.dbeaver.model.task.DBTTaskScheduleInfo;
import org.jkiss.dbeaver.model.task.DBTTaskType;
import org.jkiss.dbeaver.registry.task.TaskFolderImpl;
import org.jkiss.dbeaver.registry.task.TaskImpl;
import org.jkiss.dbeaver.registry.task.TaskRegistry;
import org.jkiss.dbeaver.registry.task.TaskRunJob;
import org.jkiss.dbeaver.registry.timezone.TimezoneRegistry;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;

public class TaskManagerImpl
implements DBTTaskManager {
    private static final Log log = Log.getLog(TaskManagerImpl.class);
    private static final Gson CONFIG_GSON = new GsonBuilder().setStrictness(Strictness.LENIENT).serializeNulls().setPrettyPrinting().create();
    final SimpleDateFormat systemDateFormat;
    private final Set<TaskRunJob> runningTasks = Collections.synchronizedSet(new HashSet());
    private Job serviceJob;
    private final BaseProjectImpl projectMetadata;
    private final List<TaskImpl> tasks = new ArrayList<TaskImpl>();
    private final List<TaskFolderImpl> tasksFolders = new ArrayList<TaskFolderImpl>();
    private final Path statisticsFolder;

    public TaskManagerImpl(BaseProjectImpl projectMetadata, Path statisticsFolder) {
        this.projectMetadata = projectMetadata;
        this.statisticsFolder = statisticsFolder;
        this.systemDateFormat = new SimpleDateFormat("yyyyMMddHHmm", Locale.ENGLISH);
        this.systemDateFormat.setTimeZone(TimeZone.getTimeZone(TimezoneRegistry.getUserDefaultTimezone()));
        this.loadConfiguration();
    }

    @NotNull
    public DBTTaskRegistry getRegistry() {
        return TaskRegistry.getInstance();
    }

    @NotNull
    public DBPProject getProject() {
        return this.projectMetadata;
    }

    @NotNull
    public DBTTask[] getAllTasks() {
        return this.tasks.toArray(new DBTTask[0]);
    }

    @Nullable
    public DBTTask getTaskById(@NotNull String id) {
        for (DBTTask dBTTask : this.tasks) {
            if (!id.equals(dBTTask.getId())) continue;
            return dBTTask;
        }
        return null;
    }

    @Nullable
    public DBTTask getTaskByName(@NotNull String name) {
        for (DBTTask dBTTask : this.tasks) {
            if (!name.equalsIgnoreCase(dBTTask.getName())) continue;
            return dBTTask;
        }
        return null;
    }

    @NotNull
    public DBTTaskType[] getExistingTaskTypes() {
        LinkedHashSet<DBTTaskType> result = new LinkedHashSet<DBTTaskType>();
        for (DBTTask dBTTask : this.tasks) {
            result.add(dBTTask.getType());
        }
        return result.toArray(new DBTTaskType[0]);
    }

    @NotNull
    public DBTTask[] getAllTaskByType(DBTTaskType task) {
        ArrayList<DBTTask> result = new ArrayList<DBTTask>();
        for (DBTTask dBTTask : this.tasks) {
            if (dBTTask.getType() != task) continue;
            result.add(dBTTask);
        }
        return result.toArray(new DBTTask[0]);
    }

    public DBTTaskFolder[] getTasksFolders() {
        return this.tasksFolders.toArray(new DBTTaskFolder[0]);
    }

    @NotNull
    public DBTTask createTask(@NotNull DBTTaskType taskDescriptor, @NotNull String label, @Nullable String description, @Nullable String taskFolderName, @NotNull Map<String, Object> properties) throws DBException {
        if (this.getTaskByName(label) != null) {
            throw new DBException("Task with name '" + label + "' already exists");
        }
        Date createTime = new Date();
        String id = UUID.randomUUID().toString();
        TaskFolderImpl taskFolder = this.searchTaskFolderByName(taskFolderName);
        TaskImpl task = this.createTask(taskDescriptor, id, label, description, createTime, createTime, taskFolder, properties);
        return task;
    }

    @NotNull
    public DBTTask createTemporaryTask(@NotNull DBTTaskType type, @NotNull String label) {
        return new TaskImpl(this.getProject(), type, "#temp", label, label, new Date(), null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public DBTTaskFolder createTaskFolder(@NotNull DBPProject project, @NotNull String folderName, @Nullable DBTTaskFolder parentFolder, @Nullable DBTTask[] folderTasks) throws DBException {
        if (!CommonUtils.isEmpty(this.tasksFolders) && this.tasksFolders.stream().anyMatch(taskFolder -> taskFolder.getName().equals(folderName))) {
            throw new DBException("Task folder with name '" + folderName + "' already exists");
        }
        TaskFolderImpl taskFolder2 = new TaskFolderImpl(folderName, parentFolder, project, (List<DBTTask>)(folderTasks != null ? new ArrayList<DBTTask>(Arrays.asList(folderTasks)) : new ArrayList()));
        List<TaskFolderImpl> list = this.tasksFolders;
        synchronized (list) {
            this.tasksFolders.add(taskFolder2);
        }
        if (parentFolder != null) {
            parentFolder.addFolderToFoldersList((DBTTaskFolder)taskFolder2);
        }
        TaskRegistry.getInstance().notifyTaskFoldersListeners(new DBTTaskFolderEvent((DBTTaskFolder)taskFolder2, DBTTaskFolderEvent.Action.TASK_FOLDER_ADD));
        return taskFolder2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTaskConfiguration(@NotNull DBTTask task) throws DBException {
        if (task.isTemporary()) {
            return;
        }
        DBTTask prevTask = this.getTaskByName(task.getName());
        if (prevTask != null && prevTask != task) {
            throw new DBException("Task with name '" + task.getName() + "' already exists");
        }
        boolean newTask = false;
        List<TaskImpl> list = this.tasks;
        synchronized (list) {
            if (!this.tasks.contains(task)) {
                this.tasks.add((TaskImpl)task);
                newTask = true;
            }
        }
        TaskRegistry.getInstance().notifyTaskListeners(new DBTTaskEvent(task, newTask ? DBTTaskEvent.Action.TASK_ADD : DBTTaskEvent.Action.TASK_UPDATE));
        if (task.getTaskFolder() != null) {
            TaskRegistry.getInstance().notifyTaskFoldersListeners(new DBTTaskFolderEvent(task.getTaskFolder(), DBTTaskFolderEvent.Action.TASK_FOLDER_UPDATE));
        }
        this.saveConfiguration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteTaskConfiguration(@NotNull DBTTask task) throws DBException {
        DBTTaskScheduleInfo info;
        DBTScheduler scheduler = TaskRegistry.getInstance().getActiveSchedulerInstance();
        if (scheduler != null && (info = scheduler.getScheduledTaskInfo(task)) != null) {
            scheduler.removeTaskSchedule(task, info);
        }
        List<TaskImpl> list = this.tasks;
        synchronized (list) {
            this.tasks.remove(task);
        }
        this.saveConfiguration();
        TaskRegistry.getInstance().notifyTaskListeners(new DBTTaskEvent(task, DBTTaskEvent.Action.TASK_REMOVE));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTaskFolder(@NotNull DBTTaskFolder taskFolder) throws DBException {
        List folderTasks;
        if (!this.tasksFolders.contains(taskFolder)) {
            throw new DBException("Task folder with name '" + taskFolder.getName() + "' is missing");
        }
        DBTTaskFolder parentFolder = taskFolder.getParentFolder();
        if (parentFolder != null) {
            parentFolder.removeFolderFromFoldersList(taskFolder);
        }
        if (!CommonUtils.isEmpty((Collection)(folderTasks = taskFolder.getTasks()))) {
            for (DBTTask task : folderTasks) {
                if (!(task instanceof TaskImpl)) continue;
                ((TaskImpl)task).setTaskFolder(parentFolder);
            }
        }
        List<TaskFolderImpl> list = this.tasksFolders;
        synchronized (list) {
            this.tasksFolders.remove(taskFolder);
        }
        this.saveConfiguration();
        TaskRegistry.getInstance().notifyTaskFoldersListeners(new DBTTaskFolderEvent(taskFolder, DBTTaskFolderEvent.Action.TASK_FOLDER_REMOVE));
    }

    public boolean hasRunningTasks() {
        return !this.runningTasks.isEmpty();
    }

    public void cancelRunningTasks() {
        Job[] tasks;
        Job[] jobArray = tasks = (Job[])this.runningTasks.toArray(Job[]::new);
        int n = tasks.length;
        int n2 = 0;
        while (n2 < n) {
            Job task = jobArray[n2];
            task.cancel();
            ++n2;
        }
    }

    @NotNull
    public Path getStatisticsFolder() {
        return this.statisticsFolder;
    }

    @NotNull
    public Path getStatisticsFolder(@NotNull DBTTask task) {
        return this.statisticsFolder.resolve(task.getId());
    }

    @NotNull
    public DBTTaskRunStatus runTask(@NotNull DBRProgressMonitor monitor, @NotNull DBTTask task, @NotNull DBTTaskExecutionListener listener) throws DBException {
        TaskRunJob job = this.createJob((TaskImpl)task, listener);
        if (this.serviceJob == null) {
            this.serviceJob = new ServiceJob();
            this.serviceJob.schedule();
        }
        this.runningTasks.add(job);
        IStatus result = job.runDirectly(monitor);
        Throwable error = result.getException();
        if (error != null) {
            this.runningTasks.remove((Object)job);
            if (error instanceof DBException) {
                DBException e = (DBException)error;
                throw e;
            }
            throw new DBException("Error executing task", error);
        }
        this.runningTasks.remove((Object)job);
        return job.getTaskRunStatus();
    }

    @NotNull
    public TaskRunJob scheduleTask(@NotNull DBTTask task, @NotNull DBTTaskExecutionListener listener) throws DBException {
        TaskRunJob runJob = this.createJob((TaskImpl)task, listener);
        runJob.schedule();
        if (this.serviceJob == null) {
            this.serviceJob = new ServiceJob();
            this.serviceJob.schedule();
        }
        return runJob;
    }

    @NotNull
    private TaskRunJob createJob(@NotNull TaskImpl task, @NotNull DBTTaskExecutionListener listener) {
        TaskRunJob runJob = new TaskRunJob(task, Locale.getDefault(), listener);
        runJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void aboutToRun(IJobChangeEvent event) {
                TaskManagerImpl.this.runningTasks.add((TaskRunJob)event.getJob());
            }

            public void done(IJobChangeEvent event) {
                TaskManagerImpl.this.runningTasks.remove((Object)((TaskRunJob)event.getJob()));
            }
        });
        return runJob;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadConfiguration() {
        if (!this.getProject().hasRealmPermission("project-datasource-view")) {
            log.warn((Object)("The user has no permission to see tasks for this project: " + this.getProject().getDisplayName()));
            return;
        }
        String configFile = null;
        try {
            configFile = this.loadConfigFile();
        }
        catch (DBException e2) {
            log.error((Object)"Error loading task configuration file.", (Throwable)e2);
        }
        if (CommonUtils.isEmpty((String)configFile)) {
            return;
        }
        Map jsonMap = JSONUtils.parseMap((Gson)CONFIG_GSON, (Reader)new StringReader(configFile));
        for (Map.Entry entry : JSONUtils.getNestedObjects((Map)jsonMap, (String)"##tasksFolders")) {
            Optional<TaskFolderImpl> first;
            String folderName = (String)entry.getKey();
            if (!CommonUtils.isNotEmpty((String)folderName)) continue;
            Object property = JSONUtils.getObjectProperty(entry.getValue(), (String)"parent");
            TaskFolderImpl parentFolder = null;
            if (property != null && (first = this.tasksFolders.stream().filter(e -> e.getName().equals(property.toString())).findFirst()).isPresent()) {
                parentFolder = first.get();
            }
            try {
                this.createTaskFolder((DBPProject)this.projectMetadata, folderName, parentFolder, new DBTTask[0]);
            }
            catch (DBException ex) {
                log.error((Object)"Error creating tasks folder.", (Throwable)ex);
            }
        }
        for (Map.Entry entry : jsonMap.entrySet()) {
            Map taskJSON = (Map)entry.getValue();
            try {
                List<Object> list;
                String id = (String)entry.getKey();
                if (id.startsWith("##tasksFolders")) continue;
                String task = JSONUtils.getString((Map)taskJSON, (String)"task");
                String label = CommonUtils.toString((Object)JSONUtils.getString((Map)taskJSON, (String)"label"), (String)id);
                String description = JSONUtils.getString((Map)taskJSON, (String)"description");
                String taskFolderName = JSONUtils.getString((Map)taskJSON, (String)"taskFolder");
                Date createTime = this.systemDateFormat.parse(JSONUtils.getString((Map)taskJSON, (String)"createTime"));
                Date updateTime = this.systemDateFormat.parse(JSONUtils.getString((Map)taskJSON, (String)"updateTime"));
                Duration maxExecutionTime = Duration.ofSeconds(JSONUtils.getInteger((Map)taskJSON, (String)"maxExecutionTime"));
                Map state = JSONUtils.getObject((Map)taskJSON, (String)"state");
                DBTTaskType taskDescriptor = this.getRegistry().getTaskType(task);
                if (taskDescriptor == null) {
                    log.error((Object)("Can't find task descriptor " + task));
                    continue;
                }
                TaskFolderImpl taskFolder = this.searchTaskFolderByName(taskFolderName);
                TaskImpl taskConfig = this.createTask(taskDescriptor, id, label, description, createTime, updateTime, taskFolder, state);
                taskConfig.setMaxExecutionTime(maxExecutionTime);
                if (taskFolder != null) {
                    taskFolder.addTaskToFolder(taskConfig);
                    if (!this.tasksFolders.contains(taskFolder)) {
                        list = this.tasksFolders;
                        synchronized (list) {
                            this.tasksFolders.add(taskFolder);
                        }
                    }
                }
                list = this.tasks;
                synchronized (list) {
                    this.tasks.add(taskConfig);
                }
            }
            catch (Exception e3) {
                log.warn((Object)"Error parsing task configuration", (Throwable)e3);
            }
        }
    }

    @NotNull
    protected TaskImpl createTask(@NotNull DBTTaskType taskType, @NotNull String id, @NotNull String label, @Nullable String description, @NotNull Date createTime, @NotNull Date updateTime, @Nullable TaskFolderImpl taskFolder, @NotNull Map<String, Object> properties) {
        TaskImpl taskConfig = new TaskImpl(this.getProject(), taskType, id, label, description, createTime, updateTime, taskFolder);
        taskConfig.setProperties(properties);
        return taskConfig;
    }

    protected String loadConfigFile() throws DBException {
        return DBWorkbench.getPlatform().getTaskController().loadTaskConfigurationFile(this.getProject().getId(), "tasks.json");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TaskFolderImpl searchTaskFolderByName(String taskFolderName) {
        TaskFolderImpl taskFolder = null;
        if (CommonUtils.isNotEmpty((String)taskFolderName) && (taskFolder = (TaskFolderImpl)DBUtils.findObject(this.tasksFolders, (String)taskFolderName)) == null) {
            taskFolder = new TaskFolderImpl(taskFolderName, null, (DBPProject)this.projectMetadata, new ArrayList<DBTTask>());
            List<TaskFolderImpl> list = this.tasksFolders;
            synchronized (list) {
                this.tasksFolders.add(taskFolder);
            }
        }
        return taskFolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveConfiguration() {
        DBPProject project = this.getProject();
        try {
            if (this.tasks.isEmpty() && CommonUtils.isEmpty(this.tasksFolders)) {
                DBWorkbench.getPlatform().getTaskController().saveTaskConfigurationFile(project.getId(), "tasks.json", null);
                return;
            }
        }
        catch (Exception e) {
            log.error((Object)"Error processing config file", (Throwable)e);
        }
        ByteArrayOutputStream dsConfigBuffer = new ByteArrayOutputStream(10000);
        try {
            Throwable throwable = null;
            Object var4_8 = null;
            try (OutputStreamWriter osw = new OutputStreamWriter((OutputStream)dsConfigBuffer, StandardCharsets.UTF_8);){
                Throwable throwable2 = null;
                Object var7_13 = null;
                try (JsonWriter jsonWriter = CONFIG_GSON.newJsonWriter((Writer)osw);){
                    List<TaskImpl> list = this.tasks;
                    synchronized (list) {
                        this.serializeTasks(jsonWriter);
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            log.error((Object)e);
            return;
        }
        try {
            DBWorkbench.getPlatform().getTaskController().saveTaskConfigurationFile(project.getId(), "tasks.json", dsConfigBuffer.toString(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            log.error((Object)"Error saving configuration to a file tasks.json", (Throwable)e);
        }
    }

    public void updateConfiguration() {
        this.saveConfiguration();
    }

    protected void cancelJobIfNeeded(@NotNull TaskRunJob job) {
    }

    private void serializeTasks(@NotNull JsonWriter jsonWriter) throws IOException {
        jsonWriter.setIndent("\t");
        jsonWriter.beginObject();
        if (!CommonUtils.isEmpty(this.tasksFolders)) {
            jsonWriter.name("##tasksFolders");
            jsonWriter.beginObject();
            for (TaskFolderImpl taskFolder : this.tasksFolders) {
                jsonWriter.name(taskFolder.getName());
                jsonWriter.beginObject();
                if (taskFolder.getParentFolder() != null) {
                    JSONUtils.field((JsonWriter)jsonWriter, (String)"parent", (String)taskFolder.getParentFolder().getName());
                }
                jsonWriter.endObject();
            }
            jsonWriter.endObject();
        }
        for (TaskImpl task : this.tasks) {
            jsonWriter.name(task.getId());
            jsonWriter.beginObject();
            JSONUtils.field((JsonWriter)jsonWriter, (String)"task", (String)task.getType().getId());
            JSONUtils.field((JsonWriter)jsonWriter, (String)"label", (String)task.getName());
            JSONUtils.field((JsonWriter)jsonWriter, (String)"description", (String)task.getDescription());
            DBTTaskFolder taskFolder = task.getTaskFolder();
            if (taskFolder != null) {
                JSONUtils.field((JsonWriter)jsonWriter, (String)"taskFolder", (String)taskFolder.getName());
            }
            JSONUtils.field((JsonWriter)jsonWriter, (String)"createTime", (String)this.systemDateFormat.format(task.getCreateTime()));
            JSONUtils.field((JsonWriter)jsonWriter, (String)"updateTime", (String)this.systemDateFormat.format(task.getUpdateTime()));
            if (task.getMaxExecutionTime().isPositive()) {
                JSONUtils.field((JsonWriter)jsonWriter, (String)"maxExecutionTime", (long)task.getMaxExecutionTime().toSeconds());
            }
            JSONUtils.serializeProperties((JsonWriter)jsonWriter, (String)"state", task.getProperties(), (boolean)true);
            jsonWriter.endObject();
        }
        jsonWriter.endObject();
    }

    private class ServiceJob
    extends Job {
        private static final int TASK_SLEEP_TIME = 1000;

        public ServiceJob() {
            super("Task canceling job");
            this.setSystem(true);
        }

        protected IStatus run(IProgressMonitor monitor) {
            CopyOnWriteArraySet<TaskRunJob> copyOfRunningTasks = new CopyOnWriteArraySet<TaskRunJob>(TaskManagerImpl.this.runningTasks);
            for (TaskRunJob taskJob : copyOfRunningTasks) {
                if (taskJob.isFinished() || taskJob.isCanceled()) continue;
                TaskManagerImpl.this.cancelJobIfNeeded(taskJob);
            }
            this.schedule(1000L);
            return Status.OK_STATUS;
        }
    }
}

