/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.navigator;

import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.navigator.DBNNode;

public class DBNEvent {
    public static final Object FORCE_REFRESH = new Object();
    public static final Object UPDATE_ON_SAVE = new Object();
    private Object source;
    private Action action;
    private NodeChange nodeChange;
    @NotNull
    private DBNNode node;

    public DBNEvent(Object source, Action action, @NotNull DBNNode node) {
        this(source, action, NodeChange.REFRESH, node);
        this.action = action;
        this.node = node;
    }

    public DBNEvent(Object source, Action action, NodeChange nodeChange, @NotNull DBNNode node) {
        this.source = source;
        this.action = action;
        this.nodeChange = nodeChange;
        this.node = node;
    }

    public Object getSource() {
        return this.source;
    }

    public Action getAction() {
        return this.action;
    }

    public NodeChange getNodeChange() {
        return this.nodeChange;
    }

    @NotNull
    public DBNNode getNode() {
        return this.node;
    }

    public String toString() {
        return String.valueOf((Object)this.action) + ":" + String.valueOf((Object)this.nodeChange) + ":" + String.valueOf(this.node);
    }

    public static enum Action {
        ADD,
        REMOVE,
        UPDATE;

    }

    public static enum NodeChange {
        BEFORE_LOAD,
        AFTER_LOAD,
        LOAD,
        UNLOAD,
        REFRESH,
        SELECT,
        STRUCT_REFRESH,
        LOCK,
        UNLOCK;

    }
}

