/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.ui.wizard;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNModel;
import org.jkiss.dbeaver.model.sql.SQLQueryContainer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.tools.transfer.DataTransferSettings;
import org.jkiss.dbeaver.tools.transfer.internal.DTMessages;
import org.jkiss.dbeaver.tools.transfer.registry.DataTransferNodeDescriptor;
import org.jkiss.dbeaver.tools.transfer.registry.DataTransferProcessorDescriptor;
import org.jkiss.dbeaver.tools.transfer.registry.DataTransferRegistry;
import org.jkiss.dbeaver.tools.transfer.ui.wizard.DataTransferWizard;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.UIWidgets;
import org.jkiss.dbeaver.ui.controls.ListContentProvider;
import org.jkiss.dbeaver.ui.dialogs.ActiveWizardPage;
import org.jkiss.utils.CommonUtils;

public class DataTransferPagePipes
extends ActiveWizardPage<DataTransferWizard> {
    public static final String DATABASE_PRODUCER_ID = "database_producer";
    public static final String DATABASE_CONSUMER_ID = "database_consumer";
    private boolean activated;
    private TableViewer nodesTable;
    private TableViewer inputsTable;

    DataTransferPagePipes(@NotNull DataTransferSettings settings) {
        super(DTMessages.data_transfer_wizard_init_title);
        if (settings.isConsumerOptional()) {
            this.setTitle(DTMessages.data_transfer_wizard_init_title);
            this.setDescription(DTMessages.data_transfer_wizard_init_description);
        } else {
            this.setTitle(DTMessages.data_transfer_wizard_producers_title);
            this.setDescription(DTMessages.data_transfer_wizard_producers_description);
        }
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = UIUtils.createComposite((Composite)parent, (int)1);
        SashForm sash = new SashForm(composite, 256);
        sash.setLayoutData((Object)new GridData(1808));
        this.createNodesTable((Composite)sash);
        this.createInputsTable((Composite)sash);
        sash.setWeights(new int[]{70, 30});
        this.setControl((Control)composite);
    }

    private void createNodesTable(Composite composite) {
        Composite panel = UIUtils.createComposite((Composite)composite, (int)1);
        this.nodesTable = new TableViewer(panel, 67588);
        GridData gd = new GridData(1808);
        gd.heightHint = 350;
        gd.widthHint = 400;
        this.nodesTable.getTable().setLayoutData((Object)gd);
        this.nodesTable.getTable().setLinesVisible(true);
        this.nodesTable.setContentProvider((IContentProvider)((IStructuredContentProvider)inputElement -> {
            if (inputElement instanceof Collection) {
                return ((Collection)inputElement).toArray();
            }
            return new Object[0];
        }));
        CellLabelProvider labelProvider = new CellLabelProvider(){

            public void update(ViewerCell cell) {
                String label;
                TransferTarget element = (TransferTarget)cell.getElement();
                if (cell.getColumnIndex() == 0) {
                    if (element.processor != null) {
                        cell.setImage(DBeaverIcons.getImage((DBPImage)element.processor.getIcon()));
                        label = element.processor.getName();
                    } else {
                        cell.setImage(DBeaverIcons.getImage((DBPImage)element.node.getIcon()));
                        label = element.node.getName();
                    }
                } else {
                    label = element.processor != null ? element.processor.getDescription() : element.node.getDescription();
                }
                cell.setText(label);
            }
        };
        TableViewerColumn columnName = new TableViewerColumn(this.nodesTable, 16384);
        columnName.setLabelProvider(labelProvider);
        columnName.getColumn().setText(DTMessages.data_transfer_wizard_init_column_exported);
        TableViewerColumn columnDesc = new TableViewerColumn(this.nodesTable, 16384);
        columnDesc.setLabelProvider(labelProvider);
        columnDesc.getColumn().setText(DTMessages.data_transfer_wizard_init_column_description);
        this.nodesTable.getTable().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DataTransferPagePipes.this.setSelectedSettings(true);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
                if (DataTransferPagePipes.this.isPageComplete()) {
                    ((DataTransferWizard)DataTransferPagePipes.this.getWizard()).getContainer().nextPressed();
                }
            }
        });
    }

    private void setSelectedSettings(boolean forceUpdate) {
        IStructuredSelection selection = (IStructuredSelection)this.nodesTable.getSelection();
        TransferTarget target = !selection.isEmpty() ? (TransferTarget)selection.getFirstElement() : null;
        DataTransferSettings settings = ((DataTransferWizard)this.getWizard()).getSettings();
        if (target == null) {
            settings.selectConsumer(null, null, true);
        } else if (settings.isConsumerOptional()) {
            if (forceUpdate || settings.getConsumer() == null) {
                settings.selectConsumer(target.node, target.processor, true);
            }
        } else if (settings.isProducerOptional() && (forceUpdate || settings.getProducer() == null)) {
            settings.selectProducer(target.node, target.processor, true);
        }
        this.updatePageCompletion();
        ((DataTransferWizard)this.getWizard()).getContainer().updateNavigationTree();
    }

    private void createInputsTable(Composite composite) {
        Composite panel = UIUtils.createComposite((Composite)composite, (int)1);
        this.inputsTable = new TableViewer(panel, 67588);
        GridData gd = new GridData(1808);
        gd.widthHint = 200;
        gd.heightHint = 200;
        this.inputsTable.getTable().setLayoutData((Object)gd);
        this.inputsTable.getTable().setLinesVisible(true);
        this.inputsTable.setContentProvider((IContentProvider)new ListContentProvider());
        UIWidgets.createTableContextMenu((Table)this.inputsTable.getTable(), null);
        final DBNModel nModel = DBWorkbench.getPlatform().getNavigatorModel();
        CellLabelProvider labelProvider = new CellLabelProvider(){

            public void update(ViewerCell cell) {
                DBSObject element = (DBSObject)cell.getElement();
                if (cell.getColumnIndex() == 0) {
                    DBNDatabaseNode objectNode = nModel.getNodeByObject(element);
                    DBPImage icon = objectNode != null ? objectNode.getNodeIconDefault() : DBValueFormatting.getObjectImage((DBPObject)element);
                    cell.setImage(DBeaverIcons.getImage((DBPImage)icon));
                    SQLQueryContainer queryContainer = (SQLQueryContainer)DBUtils.getAdapter(SQLQueryContainer.class, (Object)element);
                    if (queryContainer != null) {
                        cell.setText(CommonUtils.truncateString((String)CommonUtils.getSingleLineString((String)queryContainer.getQuery().getText()), (int)64));
                    } else {
                        cell.setText(CommonUtils.truncateString((String)DBUtils.getObjectFullName((DBPNamedObject)element, (DBPEvaluationContext)DBPEvaluationContext.UI), (int)64));
                    }
                }
            }
        };
        this.inputsTable.setLabelProvider((IBaseLabelProvider)labelProvider);
    }

    public void activatePage() {
        this.inputsTable.setInput((Object)((DataTransferWizard)this.getWizard()).getSettings().getSourceObjects());
        if (!this.activated) {
            UIUtils.asyncExec(this::loadNodeSettings);
        }
        if (this.activated && ((DataTransferWizard)this.getWizard()).getSettings().isPipeChangeRestricted()) {
            this.nodesTable.getTable().setEnabled(false);
            return;
        }
        this.activated = true;
    }

    private void loadNodeSettings() {
        if (((DataTransferWizard)this.getWizard()).getSettings().isConsumerOptional()) {
            this.loadConsumers();
        } else {
            this.loadProducers();
        }
        DataTransferNodeDescriptor consumer = ((DataTransferWizard)this.getWizard()).getSettings().getConsumer();
        DataTransferNodeDescriptor producer = ((DataTransferWizard)this.getWizard()).getSettings().getProducer();
        DataTransferProcessorDescriptor processor = ((DataTransferWizard)this.getWizard()).getSettings().getProcessor();
        List targets = (List)this.nodesTable.getInput();
        TransferTarget currentTarget = null;
        if (consumer != null || producer != null) {
            for (TransferTarget target : targets) {
                if (target.node != consumer && target.node != producer || target.processor != null && target.processor != processor) continue;
                currentTarget = target;
                break;
            }
        }
        if (currentTarget == null && !targets.isEmpty()) {
            currentTarget = (TransferTarget)targets.getFirst();
        }
        this.inputsTable.setInput((Object)((DataTransferWizard)this.getWizard()).getSettings().getSourceObjects());
        if (currentTarget != null) {
            StructuredSelection selection = new StructuredSelection((Object)currentTarget);
            this.nodesTable.setSelection((ISelection)selection);
            this.setSelectedSettings(false);
        }
        UIUtils.packColumns((Table)this.nodesTable.getTable());
        this.updatePageCompletion();
    }

    private void loadConsumers() {
        DataTransferWizard wizard = (DataTransferWizard)this.getWizard();
        DataTransferSettings settings = wizard.getSettings();
        List objects = settings.getSourceObjects();
        ArrayList<TransferTarget> transferTargets = new ArrayList<TransferTarget>();
        for (DataTransferNodeDescriptor consumer : DataTransferRegistry.getInstance().getAvailableConsumers((Collection)objects)) {
            if (consumer.isAdvancedNode() && !DBWorkbench.hasFeature((String)"database/data/transfer/advanced") || DATABASE_CONSUMER_ID.equals(consumer.getId()) && !DBWorkbench.getPlatform().getWorkspace().hasRealmPermission("database-developer") || wizard.isTaskEditor() && settings.getConsumer() != null && !settings.getConsumer().getId().equals(consumer.getId())) continue;
            List processors = consumer.getAvailableProcessors((Collection)objects);
            if (CommonUtils.isEmpty((Collection)processors)) {
                transferTargets.add(new TransferTarget(consumer, null));
                continue;
            }
            for (DataTransferProcessorDescriptor processor : processors) {
                transferTargets.add(new TransferTarget(consumer, processor));
            }
        }
        this.nodesTable.setInput(transferTargets);
    }

    private void loadProducers() {
        DataTransferWizard wizard = (DataTransferWizard)this.getWizard();
        DataTransferSettings settings = wizard.getSettings();
        List objects = settings.getSourceObjects();
        ArrayList<TransferTarget> transferTargets = new ArrayList<TransferTarget>();
        for (DataTransferNodeDescriptor producer : DataTransferRegistry.getInstance().getAvailableProducers((Collection)objects)) {
            if (producer.isAdvancedNode() && !DBWorkbench.hasFeature((String)"database/data/transfer/advanced") || DATABASE_PRODUCER_ID.equals(producer.getId()) && !DBWorkbench.getPlatform().getWorkspace().hasRealmPermission("database-developer") || wizard.isTaskEditor() && settings.getProducer() != null && !settings.getProducer().getId().equals(producer.getId())) continue;
            List processors = producer.getAvailableProcessors((Collection)objects);
            if (CommonUtils.isEmpty((Collection)processors)) {
                transferTargets.add(new TransferTarget(producer, null));
                continue;
            }
            for (DataTransferProcessorDescriptor processor : processors) {
                transferTargets.add(new TransferTarget(producer, processor));
            }
        }
        this.nodesTable.setInput(transferTargets);
    }

    protected boolean determinePageCompletion() {
        DataTransferSettings settings = ((DataTransferWizard)this.getWizard()).getSettings();
        if (settings.getDataPipes().isEmpty()) {
            this.setErrorMessage("No objects selected");
            return false;
        }
        return settings.getConsumer() != null && settings.getProducer() != null;
    }

    private static class TransferTarget {
        DataTransferNodeDescriptor node;
        DataTransferProcessorDescriptor processor;

        private TransferTarget(DataTransferNodeDescriptor node, DataTransferProcessorDescriptor processor) {
            this.node = node;
            this.processor = processor;
        }
    }
}

