/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.exasol.model.lock;

import java.math.BigInteger;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.jkiss.dbeaver.model.admin.locks.DBAServerLock;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;

public class ExasolLock
implements DBAServerLock {
    private long waitSessionId;
    private String waitUserName;
    private String waitCommandName;
    private String waitOsUser;
    private String waitClient;
    private long holdSessionId;
    private String holdClient;
    private String holdUserName;
    private String oname;
    private String status;
    private Timestamp waitLoginTime;
    private DBAServerLock hold = null;
    private List<DBAServerLock> waiters = new ArrayList<DBAServerLock>(0);

    public ExasolLock(ResultSet dbResult) {
        this.waitSessionId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"W_SESSION_ID");
        this.waitUserName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"W_USER_NAME");
        this.waitCommandName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"W_COMMAND_NAME");
        this.waitOsUser = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"W_OS_USER");
        this.waitClient = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"W_CLIENT");
        this.holdSessionId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"H_SESSION_ID");
        this.holdClient = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"H_CLIENT");
        this.oname = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"ONAME");
        this.holdUserName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"H_USER_NAME");
        this.status = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"H_STATUS");
        this.waitLoginTime = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"W_LOGIN_TIME");
    }

    public String getTitle() {
        return String.valueOf(this.waitSessionId);
    }

    public DBAServerLock getHoldBy() {
        return this.hold;
    }

    public DBAServerLock getHold() {
        return this.hold;
    }

    public BigInteger getId() {
        return BigInteger.valueOf(this.waitSessionId);
    }

    public List<DBAServerLock> waitThis() {
        return this.waiters;
    }

    public BigInteger getHoldID() {
        return BigInteger.valueOf(this.holdSessionId);
    }

    public void setHoldBy(DBAServerLock lock) {
        this.hold = lock;
    }

    public String toString() {
        return String.format("Wait %s - %d (%s) Hold - %d (%s)", this.oname, this.waitSessionId, this.waitUserName, this.holdSessionId, this.holdUserName);
    }

    @Property(viewable=true, order=1)
    public BigInteger getWait_sid() {
        return BigInteger.valueOf(this.waitSessionId);
    }

    @Property(viewable=true, order=2)
    public String getWait_osuser() {
        return this.waitOsUser;
    }

    @Property(viewable=true, order=3)
    public String getWait_user() {
        return this.waitUserName;
    }

    @Property(viewable=true, order=4)
    public String getOname() {
        return this.oname;
    }

    @Property(viewable=true, order=5)
    public String getWait_command() {
        return this.waitCommandName;
    }

    @Property(viewable=true, order=6)
    public String getWait_client() {
        return this.waitClient;
    }

    @Property(viewable=true, order=7)
    public long getHold_sid() {
        return this.holdSessionId;
    }

    @Property(viewable=true, order=9)
    public String getHold_user() {
        return this.holdUserName;
    }

    @Property(viewable=true, order=10)
    public Timestamp getLtime() {
        return this.waitLoginTime;
    }

    @Property(viewable=true, order=11)
    public String getStatus() {
        return this.status;
    }

    @Property(viewable=true, order=12)
    public String getHold_client() {
        return this.holdClient;
    }
}

