/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.onedrive.client;

import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import org.nuxeo.onedrive.client.types.Drive;
import org.nuxeo.onedrive.client.types.DriveItem;
import org.nuxeo.onedrive.client.types.Facet;

public class PatchOperation {
    private final JsonObject jsonObject = new JsonObject();

    public void rename(String newName) {
        this.jsonObject.add("name", newName);
    }

    public void move(DriveItem newParent) {
        JsonObject parentReference = new JsonObject();
        Drive rootDrive = newParent.getDrive();
        if (null != rootDrive) {
            parentReference.add("driveId", rootDrive.getId());
            parentReference.add("id", newParent.getId());
        } else if (DriveItem.ItemIdentifierType.Path == newParent.getItemIdentifierType()) {
            parentReference.add("path", newParent.getPath());
        }
        this.jsonObject.add("parentReference", (JsonValue)parentReference);
    }

    public void facet(String property, Facet facet) {
        this.jsonObject.add(property, (JsonValue)facet.toJson());
    }

    JsonObject build() {
        return this.jsonObject;
    }
}

