/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.onedrive.client;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Set;
import org.nuxeo.onedrive.client.RequestHeader;

public interface RequestExecutor
extends Closeable {
    public Upload doPost(URL var1, Set<RequestHeader> var2) throws IOException;

    public Upload doPut(URL var1, Set<RequestHeader> var2) throws IOException;

    public Response doGet(URL var1, Set<RequestHeader> var2) throws IOException;

    public Response doDelete(URL var1, Set<RequestHeader> var2) throws IOException;

    public Upload doPatch(URL var1, Set<RequestHeader> var2) throws IOException;

    public void addAuthorizationHeader(Set<RequestHeader> var1);

    public static abstract class Upload {
        public abstract OutputStream getOutputStream() throws IOException;

        public abstract Response getResponse() throws IOException;
    }

    public static abstract class Response {
        private final InputStream responseBody;

        public Response(InputStream responseBody) {
            this.responseBody = responseBody;
        }

        public abstract int getStatusCode() throws IOException;

        public abstract String getStatusMessage() throws IOException;

        public abstract String getLocation();

        public InputStream getInputStream() {
            return this.responseBody;
        }
    }
}

