/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.onedrive.client;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Objects;
import org.nuxeo.onedrive.client.OneDriveAPIException;
import org.nuxeo.onedrive.client.OneDriveRuntimeException;
import org.nuxeo.onedrive.client.QueryStringBuilder;

public class URLTemplate {
    public static final URLTemplate EMPTY_TEMPLATE = new URLTemplate("");
    private String template;

    public String getTemplate() {
        return this.template;
    }

    public URLTemplate(String template) {
        this.template = Objects.requireNonNull(template);
    }

    public URL build(String base) {
        String urlString = base + this.template;
        try {
            return new URL(urlString);
        }
        catch (MalformedURLException e) {
            throw new OneDriveRuntimeException(new OneDriveAPIException(e.getMessage(), e));
        }
    }

    public URL build(String base, Object ... values) {
        String urlString = String.format(base + this.template, values);
        try {
            return new URL(urlString);
        }
        catch (MalformedURLException e) {
            throw new OneDriveRuntimeException(new OneDriveAPIException(e.getMessage(), e));
        }
    }

    public URL build(String base, QueryStringBuilder query, Object ... values) {
        String urlString = String.format(base + this.template, values) + query.toString();
        try {
            return new URL(urlString);
        }
        catch (MalformedURLException e) {
            throw new OneDriveRuntimeException(new OneDriveAPIException(e.getMessage(), e));
        }
    }
}

