/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.onedrive.client.types;

import com.eclipsesource.json.JsonObject;
import org.nuxeo.onedrive.client.OneDriveAPI;
import org.nuxeo.onedrive.client.OneDriveAPIException;
import org.nuxeo.onedrive.client.OneDriveJsonObject;
import org.nuxeo.onedrive.client.OneDriveRuntimeException;
import org.nuxeo.onedrive.client.types.GroupItem;

public abstract class DirectoryObject {
    private final OneDriveAPI api;
    private final String id;

    protected DirectoryObject(OneDriveAPI api, String id) {
        this.api = api;
        this.id = id;
    }

    public OneDriveAPI getApi() {
        return this.api;
    }

    public String getId() {
        return this.id;
    }

    public abstract String getPath();

    public static Metadata fromJson(OneDriveAPI api, JsonObject jsonObject) {
        String type;
        switch (type = jsonObject.get("@odata.type").asString()) {
            case "#microsoft.graph.group": {
                return GroupItem.fromJson(api, jsonObject);
            }
        }
        throw new OneDriveRuntimeException(new OneDriveAPIException(String.format("The object type %s is currently not handled.", type)));
    }

    public abstract class Metadata
    extends OneDriveJsonObject {
        private String id;

        protected Metadata() {
        }

        protected Metadata(JsonObject jsonObject) {
            super(jsonObject);
        }

        public abstract DirectoryObject asDirectoryObject();

        public String getId() {
            if (null != this.id) {
                return this.id;
            }
            return DirectoryObject.this.id;
        }

        @Override
        protected void parseMember(JsonObject.Member member) {
            String name = member.getName();
            if ("id".equals(name)) {
                this.id = member.getValue().asString();
            } else {
                super.parseMember(member);
            }
        }
    }
}

