/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.s3;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DisabledConnectionCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Directory;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.io.DefaultStreamCloser;
import ch.cyberduck.core.io.StatusOutputStream;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.s3.S3AttributesFinderFeature;
import ch.cyberduck.core.s3.S3BucketCreateService;
import ch.cyberduck.core.s3.S3PathContainerService;
import ch.cyberduck.core.s3.S3Session;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.EnumSet;
import org.apache.commons.io.input.NullInputStream;
import org.apache.commons.lang3.StringUtils;
import org.jets3t.service.model.StorageObject;
import org.jets3t.service.utils.ServiceUtils;

public class S3DirectoryFeature
implements Directory<StorageObject> {
    private static final String MIMETYPE = "application/x-directory";
    private final S3Session session;
    private final PathContainerService containerService = new S3PathContainerService();
    private Write<StorageObject> writer;

    public S3DirectoryFeature(S3Session session, Write<StorageObject> writer) {
        this.session = session;
        this.writer = writer;
    }

    public Path mkdir(Path folder, String region, TransferStatus status) throws BackgroundException {
        if (this.containerService.isContainer(folder)) {
            S3BucketCreateService service = new S3BucketCreateService(this.session);
            service.create(folder, StringUtils.isBlank((CharSequence)region) ? PreferencesFactory.get().getProperty("s3.location") : region);
            return folder;
        }
        status.setChecksum(this.writer.checksum(folder, status).compute((InputStream)new NullInputStream(0L), status));
        status.setMime(MIMETYPE);
        EnumSet<AbstractPath.Type> type = EnumSet.copyOf(folder.getType());
        type.add(AbstractPath.Type.placeholder);
        StatusOutputStream out = this.writer.write(new Path(folder.getParent(), folder.getName(), type, new PathAttributes(folder.attributes())), status, (ConnectionCallback)new DisabledConnectionCallback());
        new DefaultStreamCloser().close((OutputStream)out);
        StorageObject metadata = (StorageObject)out.getStatus();
        return new Path(folder.getParent(), folder.getName(), type, new S3AttributesFinderFeature(this.session).toAttributes(metadata));
    }

    public boolean isSupported(Path workdir, String name) {
        if (workdir.isRoot() && StringUtils.isNotBlank((CharSequence)name)) {
            return ServiceUtils.isBucketNameValidDNSName((String)name);
        }
        return true;
    }

    public S3DirectoryFeature withWriter(Write<StorageObject> writer) {
        this.writer = writer;
        return this;
    }
}

