/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds;

import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.VersionId;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.http.DefaultHttpResponseExceptionMappingService;
import ch.cyberduck.core.http.HttpRange;
import ch.cyberduck.core.io.StreamCancelation;
import ch.cyberduck.core.sds.SDSApiClient;
import ch.cyberduck.core.sds.SDSExceptionMappingService;
import ch.cyberduck.core.sds.SDSSession;
import ch.cyberduck.core.sds.io.swagger.client.ApiException;
import ch.cyberduck.core.threading.BackgroundExceptionCallable;
import ch.cyberduck.core.threading.DefaultRetryCallable;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.entity.EntityBuilder;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;

public class MultipartUploadTokenOutputStream
extends OutputStream {
    private static final Logger log = Logger.getLogger(MultipartUploadTokenOutputStream.class);
    private final SDSSession session;
    private final Path file;
    private final TransferStatus overall;
    private final String uploadToken;
    private final AtomicReference<BackgroundException> canceled = new AtomicReference();
    private Long offset = 0L;
    private final Long length;

    public MultipartUploadTokenOutputStream(SDSSession session, Path file, TransferStatus status, String uploadToken) {
        this.session = session;
        this.file = file;
        this.uploadToken = uploadToken;
        this.overall = status;
        this.length = status.getOffset() + status.getLength();
    }

    @Override
    public void write(int value) throws IOException {
        throw new IOException(new UnsupportedOperationException());
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        try {
            if (null != this.canceled.get()) {
                throw this.canceled.get();
            }
            final byte[] content = Arrays.copyOfRange(b, off, len);
            final HttpEntity entity = EntityBuilder.create().setBinary(content).build();
            new DefaultRetryCallable(this.session.getHost(), (BackgroundExceptionCallable)new BackgroundExceptionCallable<Void>(){

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public Void call() throws BackgroundException {
                    SDSApiClient client = (SDSApiClient)MultipartUploadTokenOutputStream.this.session.getClient();
                    try {
                        HttpPost request = new HttpPost(String.format("%s/v4/uploads/%s", client.getBasePath(), MultipartUploadTokenOutputStream.this.uploadToken));
                        request.setEntity(entity);
                        request.setHeader("Content-Type", "application/octet-stream");
                        request.setHeader("X-Sds-Auth-Token", "");
                        if (0L != MultipartUploadTokenOutputStream.this.overall.getLength() && 0 != content.length) {
                            HttpRange range = HttpRange.byLength((long)MultipartUploadTokenOutputStream.this.offset, (long)content.length);
                            String header = MultipartUploadTokenOutputStream.this.overall.getLength() == -1L ? String.format("%d-%d/*", range.getStart(), range.getEnd()) : String.format("%d-%d/%d", range.getStart(), range.getEnd(), MultipartUploadTokenOutputStream.this.length);
                            request.addHeader("Content-Range", String.format("bytes %s", header));
                        }
                        CloseableHttpResponse response = client.getClient().execute((HttpUriRequest)request);
                        try {
                            switch (response.getStatusLine().getStatusCode()) {
                                case 201: {
                                    MultipartUploadTokenOutputStream.this.offset = MultipartUploadTokenOutputStream.this.offset + (long)content.length;
                                    return null;
                                }
                                default: {
                                    EntityUtils.updateEntity((HttpResponse)response, (HttpEntity)new BufferedHttpEntity(response.getEntity()));
                                    throw new SDSExceptionMappingService().map(new ApiException(response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase(), Collections.emptyMap(), EntityUtils.toString((HttpEntity)response.getEntity())));
                                }
                            }
                        }
                        catch (BackgroundException e) {
                            MultipartUploadTokenOutputStream.this.canceled.set(e);
                            throw e;
                        }
                        finally {
                            EntityUtils.consume((HttpEntity)response.getEntity());
                        }
                    }
                    catch (HttpResponseException e) {
                        throw new DefaultHttpResponseExceptionMappingService().map(e);
                    }
                    catch (IOException e) {
                        throw new DefaultIOExceptionMappingService().map(e);
                    }
                }
            }, (StreamCancelation)this.overall).call();
        }
        catch (BackgroundException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("MultipartUploadTokenOutputStream{");
        sb.append("uploadToken='").append(this.uploadToken).append('\'');
        sb.append(", file=").append(this.file);
        sb.append(", offset=").append(this.offset);
        sb.append(", length=").append(this.length);
        sb.append('}');
        return sb.toString();
    }

    public VersionId getVersionId() {
        return this.overall.getVersion();
    }
}

