/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds.triplecrypt;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.DescriptiveUrl;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.HostPasswordStore;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.LoginOptions;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.PasswordStoreFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.LocalAccessDeniedException;
import ch.cyberduck.core.exception.LoginCanceledException;
import ch.cyberduck.core.shared.DefaultUrlProvider;
import ch.cyberduck.core.vault.VaultCredentials;
import com.dracoon.sdk.crypto.Crypto;
import com.dracoon.sdk.crypto.error.CryptoException;
import com.dracoon.sdk.crypto.model.UserKeyPair;
import java.util.EnumSet;
import org.apache.log4j.Logger;

public class TripleCryptKeyPair {
    private static final Logger log = Logger.getLogger(TripleCryptKeyPair.class);
    private final HostPasswordStore keychain = PasswordStoreFactory.get();

    public Credentials unlock(PasswordCallback callback, Host bookmark, UserKeyPair keypair) throws CryptoException, BackgroundException {
        String passphrase = this.keychain.getPassword(this.getServiceName(bookmark, keypair.getUserPublicKey().getVersion()), this.getAccountName(bookmark));
        return this.unlock(callback, bookmark, keypair, passphrase);
    }

    public Credentials unlock(PasswordCallback callback, Host bookmark, UserKeyPair keypair, String passphrase) throws CryptoException, LoginCanceledException {
        return this.unlock(callback, bookmark, keypair, passphrase, LocaleFactory.localizedString((String)"Enter your decryption password to access encrypted data rooms.", (String)"SDS"));
    }

    private Credentials unlock(PasswordCallback callback, Host bookmark, UserKeyPair keypair, String passphrase, String message) throws LoginCanceledException, CryptoException {
        VaultCredentials credentials;
        if (null == passphrase) {
            credentials = callback.prompt(bookmark, LocaleFactory.localizedString((String)"Decryption password required", (String)"SDS"), message, new LoginOptions().icon(bookmark.getProtocol().disk()));
            if (credentials.getPassword() == null) {
                throw new LoginCanceledException();
            }
        } else {
            credentials = new VaultCredentials(passphrase).withSaved(true);
        }
        if (!Crypto.checkUserKeyPair((UserKeyPair)keypair, (String)credentials.getPassword())) {
            return this.unlock(callback, bookmark, keypair, null, String.format("%s. %s", LocaleFactory.localizedString((String)"Invalid passphrase", (String)"Credentials"), LocaleFactory.localizedString((String)"Enter your decryption password to access encrypted data rooms.", (String)"SDS")));
        }
        if (credentials.isSaved()) {
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Save encryption password for %s", bookmark));
            }
            try {
                this.keychain.addPassword(this.getServiceName(bookmark, keypair.getUserPublicKey().getVersion()), this.getAccountName(bookmark), credentials.getPassword());
            }
            catch (LocalAccessDeniedException e) {
                log.error((Object)String.format("Failure %s saving credentials for %s in password store", new Object[]{e, bookmark}));
            }
        }
        return credentials;
    }

    private String getServiceName(Host bookmark, UserKeyPair.Version version) {
        return String.format("Triple-Crypt Encryption Password (%s) - Version (%s)", bookmark.getCredentials().getUsername(), version.getValue());
    }

    private String getAccountName(Host bookmark) {
        return new DefaultUrlProvider(bookmark).toUrl(new Path(String.valueOf('/'), EnumSet.of(AbstractPath.Type.volume, AbstractPath.Type.directory))).find(DescriptiveUrl.Type.provider).getUrl();
    }
}

