/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands;

import com.google.common.base.Preconditions;
import com.spectralogic.ds3client.commands.interfaces.AbstractRequest;
import com.spectralogic.ds3client.networking.HttpVerb;
import com.spectralogic.ds3client.utils.SeekableByteChannelInputStream;
import java.io.InputStream;
import java.nio.channels.SeekableByteChannel;
import java.util.UUID;
import javax.annotation.Nonnull;

public class PutMultiPartUploadPartRequest
extends AbstractRequest {
    private final String bucketName;
    private final String objectName;
    private final int partNumber;
    private final String uploadId;
    private final long size;
    private final InputStream stream;
    private SeekableByteChannel channel;

    public PutMultiPartUploadPartRequest(String bucketName, String objectName, @Nonnull SeekableByteChannel channel, int partNumber, long size, UUID uploadId) {
        Preconditions.checkNotNull((Object)channel, (Object)"Channel may not be null.");
        this.bucketName = bucketName;
        this.objectName = objectName;
        this.partNumber = partNumber;
        this.uploadId = uploadId.toString();
        this.size = size;
        this.channel = channel;
        this.updateQueryParam("part_number", partNumber);
        this.updateQueryParam("upload_id", uploadId);
        this.stream = new SeekableByteChannelInputStream(channel);
    }

    public PutMultiPartUploadPartRequest(String bucketName, String objectName, @Nonnull SeekableByteChannel channel, int partNumber, long size, String uploadId) {
        Preconditions.checkNotNull((Object)channel, (Object)"Channel may not be null.");
        this.bucketName = bucketName;
        this.objectName = objectName;
        this.partNumber = partNumber;
        this.uploadId = uploadId;
        this.size = size;
        this.channel = channel;
        this.updateQueryParam("part_number", partNumber);
        this.updateQueryParam("upload_id", uploadId);
        this.stream = new SeekableByteChannelInputStream(channel);
    }

    public PutMultiPartUploadPartRequest(String bucketName, String objectName, int partNumber, long size, @Nonnull InputStream stream, UUID uploadId) {
        Preconditions.checkNotNull((Object)stream, (Object)"Stream may not be null.");
        this.bucketName = bucketName;
        this.objectName = objectName;
        this.partNumber = partNumber;
        this.uploadId = uploadId.toString();
        this.size = size;
        this.stream = stream;
        this.updateQueryParam("part_number", partNumber);
        this.updateQueryParam("upload_id", uploadId);
    }

    public PutMultiPartUploadPartRequest(String bucketName, String objectName, int partNumber, long size, @Nonnull InputStream stream, String uploadId) {
        Preconditions.checkNotNull((Object)stream, (Object)"Stream may not be null.");
        this.bucketName = bucketName;
        this.objectName = objectName;
        this.partNumber = partNumber;
        this.uploadId = uploadId;
        this.size = size;
        this.stream = stream;
        this.updateQueryParam("part_number", partNumber);
        this.updateQueryParam("upload_id", uploadId);
    }

    @Override
    public HttpVerb getVerb() {
        return HttpVerb.PUT;
    }

    @Override
    public String getPath() {
        return "/" + this.bucketName + "/" + this.objectName;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public int getPartNumber() {
        return this.partNumber;
    }

    public String getUploadId() {
        return this.uploadId;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public InputStream getStream() {
        return this.stream;
    }

    public SeekableByteChannel getChannel() {
        return this.channel;
    }
}

