/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.helpers.strategy.channelstrategy;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.spectralogic.ds3client.helpers.Ds3ClientHelpers;
import com.spectralogic.ds3client.helpers.channels.RangedSeekableByteChannel;
import com.spectralogic.ds3client.helpers.channels.WindowedSeekableByteChannel;
import com.spectralogic.ds3client.helpers.strategy.channelstrategy.ChannelPreparable;
import com.spectralogic.ds3client.helpers.strategy.channelstrategy.ChannelStrategy;
import com.spectralogic.ds3client.models.BulkObject;
import com.spectralogic.ds3client.models.common.Range;
import com.spectralogic.ds3client.utils.Guard;
import java.io.IOException;
import java.nio.channels.SeekableByteChannel;
import java.util.HashMap;
import java.util.Map;

public class RandomAccessChannelStrategy
implements ChannelStrategy {
    private final Object lock = new Object();
    private final Ds3ClientHelpers.ObjectChannelBuilder objectChannelBuilder;
    private final ImmutableMap<String, ImmutableMultimap<BulkObject, Range>> rangesForBlobs;
    private final ChannelPreparable channelPreparer;
    private final Map<BulkObject, SeekableByteChannel> blobChannelMap;

    public RandomAccessChannelStrategy(Ds3ClientHelpers.ObjectChannelBuilder objectChannelBuilder, ImmutableMap<String, ImmutableMultimap<BulkObject, Range>> rangesForBlobs, ChannelPreparable channelPreparer) {
        Preconditions.checkNotNull((Object)objectChannelBuilder, (Object)"objectChannelBuilder may not be null.");
        Preconditions.checkNotNull((Object)channelPreparer, (Object)"channelPreparer may not be null.");
        this.objectChannelBuilder = objectChannelBuilder;
        this.rangesForBlobs = rangesForBlobs;
        this.channelPreparer = channelPreparer;
        this.blobChannelMap = new HashMap<BulkObject, SeekableByteChannel>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SeekableByteChannel acquireChannelForBlob(BulkObject blob) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.channelPreparer.prepareChannel(blob.getName(), this.objectChannelBuilder);
            SeekableByteChannel seekableByteChannel = this.blobChannelMap.get(blob);
            if (seekableByteChannel == null) {
                seekableByteChannel = new RangedSeekableByteChannel(this.objectChannelBuilder.buildChannel(blob.getName()), this.getRangesForABlob(blob), blob.getName());
                this.blobChannelMap.put(blob, seekableByteChannel);
            }
            return new WindowedSeekableByteChannel(seekableByteChannel, this.lock, blob.getOffset(), blob.getLength());
        }
    }

    private ImmutableMultimap<BulkObject, Range> getRangesForABlob(BulkObject blob) {
        if (Guard.isMapNullOrEmpty(this.rangesForBlobs)) {
            return ImmutableMultimap.of();
        }
        ImmutableMultimap rangesForABlob = (ImmutableMultimap)this.rangesForBlobs.get((Object)blob.getName());
        if (Guard.isMultiMapNullOrEmpty((Multimap)rangesForABlob)) {
            return ImmutableMultimap.of();
        }
        return rangesForABlob;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseChannelForBlob(SeekableByteChannel seekableByteChannel, BulkObject blob) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            SeekableByteChannel cachedChannel = this.blobChannelMap.remove(blob);
            Throwable closingCachedChannelException = null;
            try {
                cachedChannel.close();
            }
            catch (Throwable t) {
                closingCachedChannelException = t;
            }
            try {
                seekableByteChannel.close();
            }
            catch (Throwable t) {
                throw new IOException(t);
            }
            if (closingCachedChannelException != null) {
                throw new IOException(closingCachedChannelException);
            }
        }
    }
}

