/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.utils;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingSeekableByteChannel
implements SeekableByteChannel {
    private static final Logger LOG = LoggerFactory.getLogger(LoggingSeekableByteChannel.class);
    private final SeekableByteChannel wrappedChannel;
    private final String channelName;

    public LoggingSeekableByteChannel(SeekableByteChannel wrappedChannel, String channelName) {
        this.wrappedChannel = wrappedChannel;
        this.channelName = channelName;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        int readCount = this.wrappedChannel.read(dst);
        LOG.info("Read {} bytes from {}", (Object)readCount, (Object)this.channelName);
        return readCount;
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        int writeCount = this.wrappedChannel.write(src);
        LOG.info("Wrote {} bytes to {}", (Object)writeCount, (Object)this.channelName);
        return writeCount;
    }

    @Override
    public long position() throws IOException {
        return this.wrappedChannel.position();
    }

    @Override
    public SeekableByteChannel position(long newPosition) throws IOException {
        return this.wrappedChannel.position(newPosition);
    }

    @Override
    public long size() throws IOException {
        return this.wrappedChannel.size();
    }

    @Override
    public SeekableByteChannel truncate(long size) throws IOException {
        return this.wrappedChannel.truncate(size);
    }

    @Override
    public boolean isOpen() {
        return this.wrappedChannel.isOpen();
    }

    @Override
    public void close() throws IOException {
        this.wrappedChannel.close();
    }
}

