/*
 * Decompiled with CFR 0.152.
 */
package com.nulabinc.zxcvbn.matchers;

import com.nulabinc.zxcvbn.matchers.ResourceLoader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class Dictionary {
    private static final String RESOURCES_PACKAGE_PATH = "com/nulabinc/zxcvbn/matchers/dictionarys/";
    private static final ResourceLoader RESOURCE_LOADER = new ResourceLoader();
    private static final String EXT = ".txt";
    private static final String UTF_8 = "UTF-8";
    private static final String[] DICTIONARY_PARAMS = new String[]{"us_tv_and_film", "english_wikipedia", "passwords", "surnames", "male_names", "female_names"};
    public static final Map<String, String[]> FREQUENCY_LISTS = Dictionary.read();

    private static String buildResourcePath(String filename) {
        return RESOURCES_PACKAGE_PATH + filename + EXT;
    }

    private static Map<String, String[]> read() {
        HashMap<String, String[]> freqLists = new HashMap<String, String[]>();
        for (String filename : DICTIONARY_PARAMS) {
            ArrayList<String> words = new ArrayList<String>();
            try (InputStream is = RESOURCE_LOADER.getInputStream(Dictionary.buildResourcePath(filename));
                 BufferedReader br = new BufferedReader(new InputStreamReader(is, UTF_8));){
                String line;
                while ((line = br.readLine()) != null) {
                    words.add(line);
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Error while reading " + filename);
            }
            freqLists.put(filename, words.toArray(new String[0]));
        }
        return freqLists;
    }
}

