/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.utils;

import com.spectralogic.ds3client.utils.Platform;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;

public final class FileUtils {
    private FileUtils() {
    }

    public static Path resolveForSymbolic(Path path) throws IOException {
        if (Files.isSymbolicLink(path)) {
            Path simLink = Files.readSymbolicLink(path);
            if (!simLink.isAbsolute()) {
                Path symLinkParent = path.toAbsolutePath().getParent();
                if (symLinkParent == null) {
                    throw new IOException("Could not resolve real path of symbolic link");
                }
                return symLinkParent.resolve(simLink);
            }
            return simLink;
        }
        return path;
    }

    public static boolean isTransferablePath(Path path) {
        if (!Platform.isWindows()) {
            try {
                BasicFileAttributes fileAttributes = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
                return fileAttributes.isRegularFile() || fileAttributes.isDirectory();
            }
            catch (NoSuchFileException e) {
                return true;
            }
            catch (IOException e) {
                return false;
            }
        }
        return true;
    }
}

