/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.onedrive;

import ch.cyberduck.core.Cache;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.onedrive.AbstractItemListService;
import ch.cyberduck.core.onedrive.GraphSession;
import ch.cyberduck.core.onedrive.features.GraphAttributesFinderFeature;
import ch.cyberduck.core.preferences.PreferencesFactory;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.nuxeo.onedrive.client.Files;
import org.nuxeo.onedrive.client.types.DriveItem;

public class GraphItemListService
extends AbstractItemListService {
    private static final Logger log = Logger.getLogger(GraphItemListService.class);
    private final GraphSession session;
    private final GraphAttributesFinderFeature attributes;

    public GraphItemListService(GraphSession session) {
        super(new GraphAttributesFinderFeature(session));
        this.session = session;
        this.attributes = new GraphAttributesFinderFeature(session);
    }

    @Override
    protected Iterator<DriveItem.Metadata> getIterator(Path directory) throws BackgroundException {
        DriveItem folder = this.session.toFolder(directory);
        return Files.getFiles((DriveItem)folder, (int)PreferencesFactory.get().getInteger("onedrive.listing.chunksize"));
    }

    @Override
    public ListService withCache(Cache<Path> cache) {
        this.attributes.withCache(cache);
        return this;
    }
}

