/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.onedrive;

import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.IdProvider;
import ch.cyberduck.core.onedrive.AbstractSharepointSession;
import ch.cyberduck.core.onedrive.GraphSession;
import ch.cyberduck.core.onedrive.SharepointSiteListService;
import ch.cyberduck.core.ssl.X509KeyManager;
import ch.cyberduck.core.ssl.X509TrustManager;
import java.util.Deque;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.onedrive.client.OneDriveAPI;
import org.nuxeo.onedrive.client.types.GroupItem;
import org.nuxeo.onedrive.client.types.Site;

public class SharepointSiteSession
extends AbstractSharepointSession {
    public SharepointSiteSession(Host host, X509TrustManager trust, X509KeyManager key) {
        super(host, trust, key);
    }

    @Override
    public boolean isSingleSite() {
        return true;
    }

    @Override
    public Site getSite(Path file) throws BackgroundException {
        Path parent = file.getParent();
        if (parent.isRoot()) {
            Site hostSite = Site.byHostname((OneDriveAPI)((OneDriveAPI)this.getClient()), (String)this.host.getHostname());
            String path = this.host.getDefaultPath();
            if (StringUtils.isBlank((CharSequence)path) || "/".equals(path)) {
                return hostSite;
            }
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            return Site.byPath((Site)hostSite, (String)path);
        }
        return Site.byId((OneDriveAPI)((OneDriveAPI)this.getClient()), (String)this.fileIdProvider.getFileid(file, (ListProgressListener)new DisabledListProgressListener()));
    }

    @Override
    public GroupItem getGroup(Path file) throws BackgroundException {
        return null;
    }

    @Override
    public <T> T _getFeature(Class<T> type) {
        if (type == ListService.class) {
            return (T)new SharepointSiteListService(this, (IdProvider)this.getFeature(IdProvider.class));
        }
        return super._getFeature(type);
    }

    @Override
    public GraphSession.ContainerItem getContainer(Path file) {
        Deque<Path> pathDeque = this.decompose(file);
        Path lastContainer = null;
        Path lastCollection = null;
        boolean exit = false;
        boolean nextExit = false;
        block8: while (!exit && pathDeque.size() > 0) {
            Path current = pathDeque.pop();
            exit = nextExit;
            switch (current.getName()) {
                case "Drives": {
                    nextExit = true;
                }
                case "Sites": {
                    lastCollection = current;
                    continue block8;
                }
            }
            lastContainer = current;
        }
        return new GraphSession.ContainerItem(lastContainer, lastCollection, exit);
    }
}

