/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.apps.utils;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.jets3t.service.impl.rest.httpclient.RestS3Service;
import org.jets3t.service.model.MultipartUpload;
import org.jets3t.service.security.AWSCredentials;
import org.jets3t.service.security.AWSDevPayCredentials;

public class DeleteMultipartUploads {
    public static void main(String[] args) throws Exception {
        if (args.length != 4 && args.length != 6) {
            System.err.println("Required arguments: <BucketName> <HoursAgo> <AWSAccessKey> <AWSSecretKey> [ <DevPayUserToken> <DevPayProductToken> ]");
            System.exit(1);
        }
        String bucketName = args[0];
        int hoursAgo = Integer.parseInt(args[1]);
        String accessKey = args[2];
        String secretKey = args[3];
        AWSCredentials credentials = null;
        if (args.length == 4) {
            credentials = new AWSCredentials(accessKey, secretKey);
        } else {
            String userToken = args[4];
            String productToken = args[5];
            credentials = new AWSDevPayCredentials(accessKey, secretKey, userToken, productToken);
        }
        RestS3Service service = new RestS3Service(credentials);
        List<MultipartUpload> multipartUploads = service.multipartListUploads(bucketName);
        long CUTOFF = System.currentTimeMillis() - (long)(hoursAgo * 60 * 60 * 1000);
        ArrayList<MultipartUpload> oldMultipartUploads = new ArrayList<MultipartUpload>();
        for (MultipartUpload multipartUpload : multipartUploads) {
            if (multipartUpload.getInitiatedDate().getTime() >= CUTOFF) continue;
            oldMultipartUploads.add(multipartUpload);
        }
        System.out.println("Of " + multipartUploads.size() + " multipart upload(s) in " + bucketName + ", " + oldMultipartUploads.size() + " are older than " + hoursAgo + " hours ago");
        if (oldMultipartUploads.size() < 1) {
            return;
        }
        System.out.print("About to delete " + oldMultipartUploads.size() + " multipart uploads, is this OK? (y/n) ");
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        String response = br.readLine();
        if (!"y".equals(response.toLowerCase()) && !"yes".equals(response.toLowerCase())) {
            System.out.println("Aborting");
            return;
        }
        for (MultipartUpload multipartUpload : oldMultipartUploads) {
            System.out.print("Deleting (aborting) " + multipartUpload + " ...");
            service.multipartAbortUpload(multipartUpload);
            System.out.println(" done.");
        }
    }
}

