/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.gui;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.jets3t.gui.JHtmlLabel;

public class AuthenticationDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = -8112836668013270984L;
    private final Insets insetsDefault = new Insets(5, 7, 5, 7);
    private JTextField domainField = null;
    private JTextField usernameField = null;
    private JPasswordField passwordField = null;
    private boolean isNtAuthentication = false;
    private String domain = "";
    private String user = "";
    private String password = "";

    public AuthenticationDialog(Frame owner, String title, String question, boolean isNtAuthentication) {
        super(owner, title, true);
        this.isNtAuthentication = isNtAuthentication;
        this.initGui(question);
    }

    public AuthenticationDialog(Dialog owner, String title, String question, boolean isNtAuthentication) {
        super(owner, title, true);
        this.isNtAuthentication = isNtAuthentication;
        this.initGui(question);
    }

    private void initGui(String question) {
        this.setResizable(false);
        this.setDefaultCloseOperation(1);
        int rowIndex = 0;
        JPanel container = new JPanel(new GridBagLayout());
        JHtmlLabel questionLabel = new JHtmlLabel(question, null);
        container.add((Component)questionLabel, new GridBagConstraints(0, rowIndex++, 2, 1, 0.0, 0.0, 10, 0, this.insetsDefault, 0, 0));
        this.domainField = new JTextField();
        this.usernameField = new JTextField();
        this.passwordField = new JPasswordField();
        if (this.isNtAuthentication) {
            container.add((Component)new JLabel("Domain:"), new GridBagConstraints(0, rowIndex, 1, 1, 0.0, 0.0, 13, 0, this.insetsDefault, 0, 0));
            container.add((Component)this.domainField, new GridBagConstraints(1, rowIndex++, 1, 1, 1.0, 0.0, 10, 2, this.insetsDefault, 0, 0));
        }
        container.add((Component)new JLabel("User:"), new GridBagConstraints(0, rowIndex, 1, 1, 0.0, 0.0, 13, 0, this.insetsDefault, 0, 0));
        container.add((Component)this.usernameField, new GridBagConstraints(1, rowIndex++, 1, 1, 1.0, 0.0, 10, 2, this.insetsDefault, 0, 0));
        container.add((Component)new JLabel("Password:"), new GridBagConstraints(0, rowIndex, 1, 1, 0.0, 0.0, 13, 0, this.insetsDefault, 0, 0));
        container.add((Component)this.passwordField, new GridBagConstraints(1, rowIndex++, 1, 1, 1.0, 0.0, 10, 2, this.insetsDefault, 0, 0));
        JPanel buttonsContainer = new JPanel(new GridBagLayout());
        final JButton cancelButton = new JButton("Cancel");
        cancelButton.setActionCommand("Cancel");
        cancelButton.addActionListener(this);
        JButton okButton = new JButton("Authenticate me");
        okButton.setActionCommand("OK");
        okButton.setDefaultCapable(true);
        okButton.addActionListener(this);
        buttonsContainer.add((Component)cancelButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, this.insetsDefault, 0, 0));
        buttonsContainer.add((Component)okButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, this.insetsDefault, 0, 0));
        container.add((Component)buttonsContainer, new GridBagConstraints(0, rowIndex++, 2, 1, 0.0, 0.0, 10, 0, this.insetsDefault, 0, 0));
        this.getRootPane().setDefaultButton(okButton);
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke("ESCAPE"), "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", new AbstractAction(){
            private static final long serialVersionUID = 3717631976908670386L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                cancelButton.doClick();
            }
        });
        this.getContentPane().add(container);
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if ("OK".equals(e.getActionCommand())) {
            if (this.isNtAuthentication) {
                this.domain = this.domainField.getText();
            }
            this.user = this.usernameField.getText();
            this.password = new String(this.passwordField.getPassword());
        } else if ("Cancel".equals(e.getActionCommand())) {
            this.domain = "";
            this.user = "";
            this.password = "";
        }
        this.setVisible(false);
    }

    public String getDomain() {
        return this.domain;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }
}

