/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.storegate;

import ch.cyberduck.core.DescriptiveUrl;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.LoginOptions;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.LoginCanceledException;
import ch.cyberduck.core.features.PromptUrlProvider;
import ch.cyberduck.core.storegate.StoregateExceptionMappingService;
import ch.cyberduck.core.storegate.StoregateIdProvider;
import ch.cyberduck.core.storegate.StoregateSession;
import ch.cyberduck.core.storegate.io.swagger.client.ApiClient;
import ch.cyberduck.core.storegate.io.swagger.client.ApiException;
import ch.cyberduck.core.storegate.io.swagger.client.api.FileSharesApi;
import ch.cyberduck.core.storegate.io.swagger.client.model.CreateFileShareRequest;
import java.net.URI;
import java.text.MessageFormat;

public class StoregateShareFeature
implements PromptUrlProvider<Void, Void> {
    private final StoregateSession session;
    private final StoregateIdProvider fileid;

    public StoregateShareFeature(StoregateSession session, StoregateIdProvider fileid) {
        this.session = session;
        this.fileid = fileid;
    }

    public boolean isSupported(Path file, PromptUrlProvider.Type type) {
        switch (type) {
            case upload: {
                return file.isDirectory();
            }
        }
        return true;
    }

    public DescriptiveUrl toDownloadUrl(Path file, Void options, PasswordCallback callback) throws BackgroundException {
        try {
            Host bookmark = this.session.getHost();
            CreateFileShareRequest request = new CreateFileShareRequest().fileId(this.fileid.getFileid(file, (ListProgressListener)new DisabledListProgressListener()));
            try {
                request.setPassword(callback.prompt(bookmark, LocaleFactory.localizedString((String)"Passphrase", (String)"Cryptomator"), MessageFormat.format(LocaleFactory.localizedString((String)"Create a passphrase required to access {0}", (String)"Credentials"), file.getName()), new LoginOptions().keychain(false).icon(bookmark.getProtocol().disk())).getPassword());
            }
            catch (LoginCanceledException loginCanceledException) {
                // empty catch block
            }
            return new DescriptiveUrl(URI.create(new FileSharesApi((ApiClient)this.session.getClient()).fileSharesPost(request).getUrl()), DescriptiveUrl.Type.signed);
        }
        catch (ApiException e) {
            throw new StoregateExceptionMappingService().map(e);
        }
    }

    public DescriptiveUrl toUploadUrl(Path file, Void options, PasswordCallback callback) throws BackgroundException {
        try {
            Host bookmark = this.session.getHost();
            CreateFileShareRequest request = new CreateFileShareRequest().fileId(this.fileid.getFileid(file, (ListProgressListener)new DisabledListProgressListener())).allowUpload(true);
            try {
                request.setPassword(callback.prompt(bookmark, LocaleFactory.localizedString((String)"Passphrase", (String)"Cryptomator"), MessageFormat.format(LocaleFactory.localizedString((String)"Create a passphrase required to access {0}", (String)"Credentials"), file.getName()), new LoginOptions().keychain(false).icon(bookmark.getProtocol().disk())).getPassword());
            }
            catch (LoginCanceledException loginCanceledException) {
                // empty catch block
            }
            return new DescriptiveUrl(URI.create(new FileSharesApi((ApiClient)this.session.getClient()).fileSharesPost(request).getUrl()), DescriptiveUrl.Type.signed);
        }
        catch (ApiException e) {
            throw new StoregateExceptionMappingService().map(e);
        }
    }
}

