/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.dav;

import ch.cyberduck.core.http.RedirectCallback;
import com.github.sardine.impl.SardineRedirectStrategy;
import java.net.URI;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolException;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.protocol.HttpContext;

public class DAVRedirectStrategy
extends SardineRedirectStrategy {
    private final RedirectCallback callback;

    public DAVRedirectStrategy(RedirectCallback callback) {
        this.callback = callback;
    }

    protected boolean isRedirectable(String method) {
        return this.callback.redirect(method);
    }

    public HttpUriRequest getRedirect(HttpRequest request, HttpResponse response, HttpContext context) throws ProtocolException {
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("PUT")) {
            return this.copyEntity((HttpEntityEnclosingRequestBase)new HttpPut(this.getLocationURI(request, response, context)), request);
        }
        return super.getRedirect(request, response, context);
    }

    protected URI createLocationURI(String location) throws ProtocolException {
        return super.createLocationURI(StringUtils.replaceAll((String)location, (String)" ", (String)"%20"));
    }

    private HttpUriRequest copyEntity(HttpEntityEnclosingRequestBase redirect, HttpRequest original) {
        if (original instanceof HttpEntityEnclosingRequest) {
            redirect.setEntity(((HttpEntityEnclosingRequest)original).getEntity());
        }
        return redirect;
    }
}

