/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.dav;

import ch.cyberduck.core.dav.DAVTimestampFeature;
import com.github.sardine.impl.handler.MultiStatusResponseHandler;
import com.github.sardine.model.Activelock;
import com.github.sardine.model.Collection;
import com.github.sardine.model.Creationdate;
import com.github.sardine.model.Displayname;
import com.github.sardine.model.Getcontentlength;
import com.github.sardine.model.Getcontenttype;
import com.github.sardine.model.Getetag;
import com.github.sardine.model.Getlastmodified;
import com.github.sardine.model.Lockdiscovery;
import com.github.sardine.model.Locktoken;
import com.github.sardine.model.Multistatus;
import com.github.sardine.model.Prop;
import com.github.sardine.model.Propstat;
import com.github.sardine.model.Resourcetype;
import com.github.sardine.model.Response;
import com.github.sardine.util.SardineUtil;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class SaxPropFindResponseHandler
extends MultiStatusResponseHandler {
    private static final Logger log = Logger.getLogger(SaxPropFindResponseHandler.class);

    protected Multistatus getMultistatus(InputStream stream) throws IOException {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setNamespaceAware(true);
        try {
            SAXParser saxParser = spf.newSAXParser();
            XMLReader xmlReader = saxParser.getXMLReader();
            SaxHandler handler = new SaxHandler();
            xmlReader.setContentHandler(handler);
            xmlReader.setErrorHandler(new LoggingErrorHandler());
            xmlReader.parse(new InputSource(stream));
            return handler.getMultistatus();
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new IOException("Not a valid DAV response", e);
        }
    }

    private static final class SaxHandler
    extends DefaultHandler {
        private Multistatus multistatus;
        private Response response;
        private Propstat propstat;
        private Prop prop;
        private Resourcetype type;
        private Lockdiscovery lockdiscovery;
        private Activelock activelock;
        private Locktoken locktoken;
        private final StringBuilder text = new StringBuilder();
        private final Element root = SardineUtil.createElement((QName)SardineUtil.createQNameWithCustomNamespace((String)"root"));

        private SaxHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            switch (localName) {
                case "multistatus": {
                    this.multistatus = new Multistatus();
                    break;
                }
                case "response": {
                    this.response = new Response();
                    if (this.multistatus == null) break;
                    this.multistatus.getResponse().add(this.response);
                    break;
                }
                case "propstat": {
                    this.propstat = new Propstat();
                    if (this.response == null) break;
                    this.response.getPropstat().add(this.propstat);
                    break;
                }
                case "prop": {
                    this.prop = new Prop();
                    if (this.propstat == null) break;
                    this.propstat.setProp(this.prop);
                    break;
                }
                case "resourcetype": {
                    this.type = new Resourcetype();
                    if (this.prop == null) break;
                    this.prop.setResourcetype(this.type);
                    break;
                }
                case "lockdiscovery": {
                    this.lockdiscovery = new Lockdiscovery();
                    if (this.prop == null) break;
                    this.prop.setLockdiscovery(this.lockdiscovery);
                    break;
                }
                case "activelock": {
                    this.activelock = new Activelock();
                    if (this.lockdiscovery == null) break;
                    this.lockdiscovery.getActivelock().add(this.activelock);
                    break;
                }
                case "locktoken": {
                    this.locktoken = new Locktoken();
                    if (this.activelock == null) break;
                    this.activelock.setLocktoken(this.locktoken);
                    break;
                }
                case "collection": {
                    this.type.setCollection(new Collection());
                }
            }
            this.text.setLength(0);
            this.text.trimToSize();
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            this.text.append(new String(ch, start, length));
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            if (StringUtils.isBlank((CharSequence)this.text.toString())) {
                return;
            }
            if (this.response != null) {
                switch (localName) {
                    case "href": {
                        if (this.locktoken != null) {
                            this.locktoken.getHref().add(this.text.toString());
                            break;
                        }
                        this.response.getHref().add(this.text.toString());
                    }
                }
            }
            if (this.propstat != null) {
                switch (localName) {
                    case "status": {
                        this.propstat.setStatus(this.text.toString());
                    }
                }
            }
            if (this.prop != null) {
                switch (localName) {
                    case "creationdate": {
                        Creationdate value = new Creationdate();
                        value.getContent().add(this.text.toString());
                        this.prop.setCreationdate(value);
                        break;
                    }
                    case "displayname": {
                        Displayname value = new Displayname();
                        value.getContent().add(this.text.toString());
                        this.prop.setDisplayname(value);
                        break;
                    }
                    case "getcontentlength": {
                        Getcontentlength value = new Getcontentlength();
                        value.getContent().add(this.text.toString());
                        this.prop.setGetcontentlength(value);
                        break;
                    }
                    case "getcontenttype": {
                        Getcontenttype value = new Getcontenttype();
                        value.getContent().add(this.text.toString());
                        this.prop.setGetcontenttype(value);
                        break;
                    }
                    case "getlastmodified": {
                        Getlastmodified value = new Getlastmodified();
                        value.getContent().add(this.text.toString());
                        this.prop.setGetlastmodified(value);
                        break;
                    }
                    case "getetag": {
                        Getetag value = new Getetag();
                        value.getContent().add(this.text.toString());
                        this.prop.setGetetag(value);
                        break;
                    }
                    case "lastmodified_server": {
                        Element element = SardineUtil.createElement((Element)this.root, (QName)DAVTimestampFeature.LAST_MODIFIED_SERVER_CUSTOM_NAMESPACE);
                        element.setTextContent(this.text.toString());
                        this.prop.getAny().add(element);
                        break;
                    }
                    case "lastmodified": {
                        Element element = SardineUtil.createElement((Element)this.root, (QName)DAVTimestampFeature.LAST_MODIFIED_CUSTOM_NAMESPACE);
                        element.setTextContent(this.text.toString());
                        this.prop.getAny().add(element);
                        break;
                    }
                }
            }
            switch (localName) {
                case "response": {
                    this.response = null;
                    break;
                }
                case "propstat": {
                    this.propstat = null;
                    break;
                }
                case "prop": {
                    this.prop = null;
                    break;
                }
                case "lockdiscovery": {
                    this.lockdiscovery = null;
                    break;
                }
                case "activelock": {
                    this.activelock = null;
                    break;
                }
                case "locktoken": {
                    this.locktoken = null;
                }
            }
            if (!"DAV:".equals(uri) && this.prop != null) {
                Element element = SardineUtil.createElement((Element)this.root, (QName)new QName(uri, localName, "d"));
                element.setTextContent(this.text.toString());
                this.prop.getAny().add(element);
            }
        }

        public Multistatus getMultistatus() {
            return this.multistatus;
        }
    }

    private static final class LoggingErrorHandler
    implements ErrorHandler {
        private LoggingErrorHandler() {
        }

        @Override
        public void warning(SAXParseException e) throws SAXException {
            log.warn((Object)String.format("Parser warning %s", e));
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            log.error((Object)String.format("Parser error %s", e));
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            log.error((Object)String.format("Fatal parser error %s", e));
            throw e;
        }
    }
}

