/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.gmss.util;

import org.bouncycastle.crypto.Digest;

public class WinternitzOTSVerify {
    private Digest messDigestOTS;
    private int mdsize;
    private int w;

    public WinternitzOTSVerify(Digest digest, int w) {
        this.w = w;
        this.messDigestOTS = digest;
        this.mdsize = this.messDigestOTS.getDigestSize();
    }

    public int getSignatureLength() {
        int mdsize = this.messDigestOTS.getDigestSize();
        int size = ((mdsize << 3) + (this.w - 1)) / this.w;
        int logs = this.getLog((size << this.w) + 1);
        return mdsize * (size += (logs + this.w - 1) / this.w);
    }

    public byte[] Verify(byte[] message, byte[] signature) {
        int d;
        byte[] hash = new byte[this.mdsize];
        this.messDigestOTS.update(message, 0, message.length);
        this.messDigestOTS.doFinal(hash, 0);
        int size = ((this.mdsize << 3) + (this.w - 1)) / this.w;
        int logs = this.getLog((size << this.w) + 1);
        int keysize = size + (logs + this.w - 1) / this.w;
        int testKeySize = this.mdsize * keysize;
        if (testKeySize != signature.length) {
            return null;
        }
        byte[] testKey = new byte[testKeySize];
        int c = 0;
        int counter = 0;
        if (8 % this.w == 0) {
            int test;
            int i;
            d = 8 / this.w;
            int k = (1 << this.w) - 1;
            for (i = 0; i < hash.length; ++i) {
                for (int j = 0; j < d; ++j) {
                    test = hash[i] & k;
                    c += test;
                    this.hashSignatureBlock(signature, counter * this.mdsize, k - test, testKey, counter * this.mdsize);
                    hash[i] = (byte)(hash[i] >>> this.w);
                    ++counter;
                }
            }
            c = (size << this.w) - c;
            for (i = 0; i < logs; i += this.w) {
                test = c & k;
                this.hashSignatureBlock(signature, counter * this.mdsize, k - test, testKey, counter * this.mdsize);
                c >>>= this.w;
                ++counter;
            }
        } else if (this.w < 8) {
            int j;
            int test;
            long big8;
            int i;
            d = this.mdsize / this.w;
            int k = (1 << this.w) - 1;
            int ii = 0;
            for (i = 0; i < d; ++i) {
                int j2;
                big8 = 0L;
                for (j2 = 0; j2 < this.w; ++j2) {
                    big8 ^= (long)((hash[ii] & 0xFF) << (j2 << 3));
                    ++ii;
                }
                for (j2 = 0; j2 < 8; ++j2) {
                    test = (int)(big8 & (long)k);
                    c += test;
                    this.hashSignatureBlock(signature, counter * this.mdsize, k - test, testKey, counter * this.mdsize);
                    big8 >>>= this.w;
                    ++counter;
                }
            }
            d = this.mdsize % this.w;
            big8 = 0L;
            for (j = 0; j < d; ++j) {
                big8 ^= (long)((hash[ii] & 0xFF) << (j << 3));
                ++ii;
            }
            d <<= 3;
            for (j = 0; j < d; j += this.w) {
                test = (int)(big8 & (long)k);
                c += test;
                this.hashSignatureBlock(signature, counter * this.mdsize, k - test, testKey, counter * this.mdsize);
                big8 >>>= this.w;
                ++counter;
            }
            c = (size << this.w) - c;
            for (i = 0; i < logs; i += this.w) {
                test = c & k;
                this.hashSignatureBlock(signature, counter * this.mdsize, k - test, testKey, counter * this.mdsize);
                c >>>= this.w;
                ++counter;
            }
        } else if (this.w < 57) {
            long test8;
            int j;
            int ii;
            long big8;
            int rest;
            int s;
            d = (this.mdsize << 3) - this.w;
            int k = (1 << this.w) - 1;
            byte[] hlp = new byte[this.mdsize];
            int r = 0;
            while (r <= d) {
                s = r >>> 3;
                rest = r % 8;
                int f = (r += this.w) + 7 >>> 3;
                big8 = 0L;
                ii = 0;
                for (j = s; j < f; ++j) {
                    big8 ^= (long)((hash[j] & 0xFF) << (ii << 3));
                    ++ii;
                }
                c = (int)((long)c + test8);
                System.arraycopy(signature, counter * this.mdsize, hlp, 0, this.mdsize);
                for (test8 = (big8 >>>= rest) & (long)k; test8 < (long)k; ++test8) {
                    this.messDigestOTS.update(hlp, 0, hlp.length);
                    this.messDigestOTS.doFinal(hlp, 0);
                }
                System.arraycopy(hlp, 0, testKey, counter * this.mdsize, this.mdsize);
                ++counter;
            }
            s = r >>> 3;
            if (s < this.mdsize) {
                rest = r % 8;
                big8 = 0L;
                ii = 0;
                for (j = s; j < this.mdsize; ++j) {
                    big8 ^= (long)((hash[j] & 0xFF) << (ii << 3));
                    ++ii;
                }
                c = (int)((long)c + test8);
                System.arraycopy(signature, counter * this.mdsize, hlp, 0, this.mdsize);
                for (test8 = (big8 >>>= rest) & (long)k; test8 < (long)k; ++test8) {
                    this.messDigestOTS.update(hlp, 0, hlp.length);
                    this.messDigestOTS.doFinal(hlp, 0);
                }
                System.arraycopy(hlp, 0, testKey, counter * this.mdsize, this.mdsize);
                ++counter;
            }
            c = (size << this.w) - c;
            for (int i = 0; i < logs; i += this.w) {
                System.arraycopy(signature, counter * this.mdsize, hlp, 0, this.mdsize);
                for (test8 = (long)(c & k); test8 < (long)k; ++test8) {
                    this.messDigestOTS.update(hlp, 0, hlp.length);
                    this.messDigestOTS.doFinal(hlp, 0);
                }
                System.arraycopy(hlp, 0, testKey, counter * this.mdsize, this.mdsize);
                c >>>= this.w;
                ++counter;
            }
        }
        this.messDigestOTS.update(testKey, 0, testKey.length);
        byte[] TKey = new byte[this.mdsize];
        this.messDigestOTS.doFinal(TKey, 0);
        return TKey;
    }

    public int getLog(int intValue) {
        int log = 1;
        int i = 2;
        while (i < intValue) {
            i <<= 1;
            ++log;
        }
        return log;
    }

    private void hashSignatureBlock(byte[] sig, int sigOff, int rounds, byte[] buf, int bufOff) {
        if (rounds < 1) {
            System.arraycopy(sig, sigOff, buf, bufOff, this.mdsize);
        } else {
            this.messDigestOTS.update(sig, sigOff, this.mdsize);
            this.messDigestOTS.doFinal(buf, bufOff);
            while (--rounds > 0) {
                this.messDigestOTS.update(buf, bufOff, this.mdsize);
                this.messDigestOTS.doFinal(buf, bufOff);
            }
        }
    }
}

